/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model.custom;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureChamberGlass;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class PressureGlassModel
implements IDynamicBakedModel {
    private static final int TEXTURE_COUNT = 47;
    private static final TextureAtlasSprite[] SPRITE_CACHE = new TextureAtlasSprite[47];
    private final Function<Material, TextureAtlasSprite> spriteGetter;
    private static final BakedQuad[][] QUAD_CACHE = new BakedQuad[6][];
    private static final List<List<Vec3d>> VECS;

    private PressureGlassModel(Function<Material, TextureAtlasSprite> spriteGetter) {
        this.spriteGetter = spriteGetter;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        if (side == null || extraData == EmptyModelData.INSTANCE) {
            return Collections.emptyList();
        }
        int textureIndex = (Integer)extraData.getData(TileEntityPressureChamberGlass.DIR_PROPS.get(side.func_176745_a()));
        return Collections.singletonList(this.getCachedQuad(textureIndex, side));
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getSprite(0);
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    private void putVertex(BakedQuadBuilder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b, float a) {
        ImmutableList elements = builder.getVertexFormat().func_227894_c_().asList();
        block6: for (int e = 0; e < elements.size(); ++e) {
            switch (((VertexFormatElement)elements.get(e)).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{r, g, b, a});
                    continue block6;
                }
                case UV: {
                    if (((VertexFormatElement)elements.get(e)).func_177369_e() == 0) {
                        float iu = sprite.func_94214_a((double)u);
                        float iv = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{iu, iv});
                        continue block6;
                    }
                    builder.put(e, new float[0]);
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad getCachedQuad(int textureIndex, Direction side) {
        if (QUAD_CACHE[side.func_176745_a()][textureIndex] == null) {
            List<Vec3d> v = VECS.get(side.func_176745_a());
            PressureGlassModel.QUAD_CACHE[side.func_176745_a()][textureIndex] = this.createQuad(v.get(0), v.get(1), v.get(2), v.get(3), this.getSprite(textureIndex), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        return QUAD_CACHE[side.func_176745_a()][textureIndex];
    }

    private TextureAtlasSprite getSprite(int textureIndex) {
        if (SPRITE_CACHE[textureIndex] == null) {
            PressureGlassModel.SPRITE_CACHE[textureIndex] = this.spriteGetter.apply(new Material(AtlasTexture.field_110575_b, new ResourceLocation("pneumaticcraft:block/pressure_chamber/windows/window_" + (textureIndex + 1))));
        }
        return SPRITE_CACHE[textureIndex];
    }

    private BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite, float r, float g, float b, float a) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f, sprite, r, g, b, a);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, 16.0f, sprite, r, g, b, a);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 16.0f, 16.0f, sprite, r, g, b, a);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 16.0f, 0.0f, sprite, r, g, b, a);
        return builder.build();
    }

    static {
        for (int i = 0; i < 6; ++i) {
            PressureGlassModel.QUAD_CACHE[i] = new BakedQuad[47];
        }
        VECS = new ArrayList<List<Vec3d>>();
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(1.0, 0.0, 0.0), (Object)new Vec3d(1.0, 0.0, 1.0), (Object)new Vec3d(0.0, 0.0, 1.0), (Object)new Vec3d(0.0, 0.0, 0.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(0.0, 1.0, 0.0), (Object)new Vec3d(0.0, 1.0, 1.0), (Object)new Vec3d(1.0, 1.0, 1.0), (Object)new Vec3d(1.0, 1.0, 0.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(1.0, 1.0, 0.0), (Object)new Vec3d(1.0, 0.0, 0.0), (Object)new Vec3d(0.0, 0.0, 0.0), (Object)new Vec3d(0.0, 1.0, 0.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(0.0, 1.0, 1.0), (Object)new Vec3d(0.0, 0.0, 1.0), (Object)new Vec3d(1.0, 0.0, 1.0), (Object)new Vec3d(1.0, 1.0, 1.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(0.0, 1.0, 0.0), (Object)new Vec3d(0.0, 0.0, 0.0), (Object)new Vec3d(0.0, 0.0, 1.0), (Object)new Vec3d(0.0, 1.0, 1.0)));
        VECS.add((List<Vec3d>)ImmutableList.of((Object)new Vec3d(1.0, 1.0, 1.0), (Object)new Vec3d(1.0, 0.0, 1.0), (Object)new Vec3d(1.0, 0.0, 0.0), (Object)new Vec3d(1.0, 1.0, 0.0)));
    }

    private static class Geometry
    implements IModelGeometry<Geometry> {
        private Geometry() {
        }

        public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
            return new PressureGlassModel(spriteGetter);
        }

        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            ArrayList<Material> res = new ArrayList<Material>();
            for (int i = 0; i < 47; ++i) {
                res.add(new Material(AtlasTexture.field_110575_b, new ResourceLocation("pneumaticcraft:block/pressure_chamber/windows/window_" + (i + 1))));
            }
            return res;
        }
    }

    public static enum Loader implements IModelLoader<Geometry>
    {
        INSTANCE;


        public void func_195410_a(IResourceManager resourceManager) {
        }

        public Geometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new Geometry();
        }
    }
}

