/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import com.mojang.authlib.Agent;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilUserAuthentication;
import com.mojang.util.UUIDTypeAdapter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import technicianlp.reauth.ReAuth;

public final class AuthHelper
extends YggdrasilUserAuthentication {
    private static final long cacheTime = 300000L;
    private static Field sessionField = ObfuscationReflectionHelper.findField(Minecraft.class, (String)"field_71449_j");
    private static Field tokenField;
    private SessionStatus status = SessionStatus.Unknown;
    private long lastCheck = 0L;
    private YggdrasilAuthenticationService loginService;
    private boolean returnLoginService = false;
    private Pattern namePattern = Pattern.compile("[A-Za-z0-9_]{2,16}");

    public AuthHelper() {
        super(new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), null), Agent.MINECRAFT);
        this.loginService = new YggdrasilAuthenticationService(Minecraft.func_71410_x().func_110437_J(), UUID.randomUUID().toString());
    }

    public SessionStatus getSessionStatus(boolean force) {
        if (force || this.lastCheck + 300000L < System.currentTimeMillis()) {
            this.status = SessionStatus.Unknown;
        }
        if (this.status == SessionStatus.Unknown) {
            this.status = SessionStatus.Refreshing;
            this.lastCheck = System.currentTimeMillis();
            Thread t = new Thread(this::updateSessionStatus, "ReAuth Session Validator");
            t.setDaemon(true);
            t.start();
        }
        return this.status;
    }

    private void updateSessionStatus() {
        this.setToken(this.getSession().func_148254_d());
        boolean valid = false;
        try {
            valid = this.checkTokenValidity();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        this.status = valid ? SessionStatus.Valid : SessionStatus.Invalid;
        this.lastCheck = System.currentTimeMillis();
    }

    public YggdrasilAuthenticationService getAuthenticationService() {
        if (this.returnLoginService) {
            return this.loginService;
        }
        return super.getAuthenticationService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String user, char[] password, boolean savePassword) throws AuthenticationException {
        this.setUsername(user);
        String pw = new String(password);
        this.setPassword(pw);
        try {
            this.returnLoginService = true;
            this.logInWithPassword();
            this.returnLoginService = false;
            String username = this.getSelectedProfile().getName();
            String uuid = UUIDTypeAdapter.fromUUID((UUID)this.getSelectedProfile().getId());
            String access = this.getAuthenticatedToken();
            String type = this.getUserType().getName();
            Session session = new Session(username, uuid, access, type);
            session.setProperties(this.getUserProperties());
            this.logOut();
            this.setSession(session);
            ReAuth.config.setCredentials(username, user, savePassword ? pw : "");
        }
        finally {
            this.logOut();
            this.returnLoginService = false;
        }
    }

    public void offline(String username) {
        UUID uuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
        this.setSession(new Session(username, uuid.toString(), "invalid", "legacy"));
        ReAuth.log.info("Offline Username set!");
        ReAuth.config.setCredentials(username, "", "");
    }

    private void setToken(String accessToken) {
        try {
            tokenField.set((Object)this, accessToken);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed Reflective Access", e);
        }
    }

    private Session getSession() {
        return Minecraft.func_71410_x().func_110432_I();
    }

    private void setSession(Session s) {
        try {
            sessionField.set(Minecraft.func_71410_x(), s);
            this.status = SessionStatus.Unknown;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed Reflective Access", e);
        }
    }

    public boolean isValidName(String username) {
        return this.namePattern.matcher(username).matches();
    }

    static {
        try {
            tokenField = YggdrasilUserAuthentication.class.getDeclaredField("accessToken");
            tokenField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed Reflective access", e);
        }
    }

    public static enum SessionStatus {
        Valid("valid"),
        Unknown("unknown"),
        Refreshing("unknown"),
        Invalid("invalid");

        private final String translationKey;

        private SessionStatus(String translationKey) {
            this.translationKey = "reauth.status." + translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

