/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.selection;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import vswe.stevesfactory.api.logic.IProcedureType;
import vswe.stevesfactory.library.gui.RenderingHelper;
import vswe.stevesfactory.library.gui.debug.RenderEventDispatcher;
import vswe.stevesfactory.library.gui.screen.WidgetScreen;
import vswe.stevesfactory.library.gui.widget.AbstractWidget;
import vswe.stevesfactory.library.gui.widget.mixin.LeafWidgetMixin;
import vswe.stevesfactory.ui.manager.editor.EditorPanel;
import vswe.stevesfactory.ui.manager.selection.IComponentChoice;
import vswe.stevesfactory.ui.manager.selection.SelectionPanel;

public class SingularComponentChoice
extends AbstractWidget
implements IComponentChoice,
LeafWidgetMixin {
    private final IProcedureType<?> type;

    public SingularComponentChoice(IProcedureType<?> type) {
        super(0, 0, 16, 16);
        this.type = type;
    }

    @Override
    public void render(int mouseX, int mouseY, float particleTicks) {
        RenderEventDispatcher.onPreRender(this, mouseX, mouseY);
        this.renderBackground(mouseX, mouseY);
        RenderingHelper.drawCompleteTexture(this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteXRight(), this.getAbsoluteYBottom(), this.getIcon());
        if (this.isInside(mouseX, mouseY)) {
            WidgetScreen.getCurrent().setHoveringText(this.type.getLocalizedName(), mouseX, mouseY);
        }
        RenderEventDispatcher.onPostRender(this, mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.createFlowComponent(this.type);
        this.getWindow().setFocusedWidget(this);
        return true;
    }

    public ResourceLocation getIcon() {
        return this.type.getIcon();
    }

    @Override
    @Nonnull
    public SelectionPanel getParentWidget() {
        return Objects.requireNonNull((SelectionPanel)super.getParentWidget());
    }

    @Override
    public EditorPanel getEditorPanel() {
        return this.getParentWidget().getParentWidget().editorPanel;
    }
}

