/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.selection;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import vswe.stevesfactory.StevesFactoryManager;
import vswe.stevesfactory.api.StevesFactoryManagerAPI;
import vswe.stevesfactory.api.logic.IProcedureType;
import vswe.stevesfactory.api.visibility.GUIVisibility;

public final class ComponentGroup {
    public static final Set<IProcedureType<?>> groupedTypes = new HashSet();
    public static final Set<IProcedureType<?>> ungroupedTypes = new HashSet();
    public static final List<ComponentGroup> groups = new ArrayList<ComponentGroup>();
    private static final String DEFAULT_COMPONENTS_PATH = "/assets/sfm/component_groups/";
    private static final String ORDER_DECLARATION_FILE = "@order.json";
    private ResourceLocation registryName;
    private ResourceLocation icon;
    private String translationKey;
    private List<IProcedureType<?>> members = new ArrayList();

    private static File getConfigDirectory() {
        return new File("./config/sfm/component_groups/");
    }

    public static void reload(boolean reset) {
        ComponentGroup.cleanCache();
        File directory = ComponentGroup.getConfigDirectory();
        JsonParser parser = new JsonParser();
        if (reset) {
            try {
                FileUtils.deleteDirectory((File)directory);
                ComponentGroup.copySettings(parser, directory);
            }
            catch (IOException e) {
                StevesFactoryManager.logger.error("Error resetting component group configs", (Throwable)e);
            }
        } else {
            String[] list = directory.list();
            if (!directory.exists() || list == null || list.length == 0) {
                ComponentGroup.copySettings(parser, directory);
            }
        }
        try {
            ComponentGroup.setupInternal(parser, directory);
        }
        catch (IOException e) {
            StevesFactoryManager.logger.error("Error setting up groups", (Throwable)e);
        }
        ComponentGroup.categorizeTypes();
    }

    private static void cleanCache() {
        groups.clear();
        groupedTypes.clear();
        ungroupedTypes.clear();
    }

    private static void copySettings(JsonParser parser, File configDir) {
        Throwable throwable;
        boolean success = configDir.mkdirs();
        String ordersFileName = ORDER_DECLARATION_FILE;
        try {
            throwable = null;
            try (InputStream loaderIn = StevesFactoryManager.class.getResourceAsStream("/assets/sfm/component_groups/@loader.json");){
                InputStreamReader loadReader = new InputStreamReader(loaderIn);
                JsonObject loaderRoot = parser.parse((Reader)loadReader).getAsJsonObject();
                JsonArray files = loaderRoot.getAsJsonArray("files");
                for (JsonElement element : files) {
                    String fileName = element.getAsString();
                    String filePath = DEFAULT_COMPONENTS_PATH + fileName;
                    try {
                        InputStream fileIn = StevesFactoryManager.class.getResourceAsStream(filePath);
                        Throwable throwable2 = null;
                        try {
                            Files.copy(fileIn, new File(configDir.getPath() + "/" + fileName).toPath(), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (fileIn == null) continue;
                            if (throwable2 != null) {
                                try {
                                    fileIn.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            fileIn.close();
                        }
                    }
                    catch (IOException e) {
                        StevesFactoryManager.logger.error("Error copying default component group config file {}", (Object)filePath, (Object)e);
                    }
                }
                JsonElement ordersElement = loaderRoot.get("orderFile");
                if (ordersElement != null) {
                    ordersFileName = ordersElement.getAsString();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
        }
        catch (IOException e) {
            StevesFactoryManager.logger.error("Error reading loader config", (Throwable)e);
        }
        try {
            throwable = null;
            try (InputStream orderIn = StevesFactoryManager.class.getResourceAsStream(DEFAULT_COMPONENTS_PATH + ordersFileName);){
                Files.copy(orderIn, new File(configDir.getPath() + "/" + ORDER_DECLARATION_FILE).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (IOException e) {
            StevesFactoryManager.logger.error("Error copying default component group order config", (Throwable)e);
        }
    }

    private static void setupInternal(JsonParser parser, File directory) throws IOException {
        Object2IntOpenHashMap orders = new Object2IntOpenHashMap();
        File orderFile = new File(directory, ORDER_DECLARATION_FILE);
        File[] fileArray = null;
        try (FileReader reader = new FileReader(orderFile);){
            JsonObject root = parser.parse((Reader)reader).getAsJsonObject();
            JsonArray entries = root.getAsJsonArray("order");
            int i = 1;
            for (JsonElement entry : entries) {
                String name = entry.getAsString();
                orders.put((Object)name, i);
                ++i;
            }
        }
        catch (Throwable object) {
            fileArray = object;
            throw object;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            String fileName = file.getName();
            if (!"json".equals(FilenameUtils.getExtension((String)fileName)) || ORDER_DECLARATION_FILE.equals(fileName)) continue;
            try (FileReader reader = new FileReader(file);){
                JsonElement rootElement = parser.parse((Reader)reader);
                ComponentGroup group = new ComponentGroup();
                group.setup(rootElement);
                groups.add(group);
            }
        }
        groups.sort(Comparator.comparingInt(arg_0 -> ComponentGroup.lambda$setupInternal$0((Object2IntMap)orders, arg_0)));
    }

    private static void categorizeTypes() {
        for (ComponentGroup group : groups) {
            groupedTypes.addAll(group.members);
        }
        for (IProcedureType type : StevesFactoryManagerAPI.getProceduresRegistry().getValues()) {
            if (groupedTypes.contains(type) || !GUIVisibility.isEnabled(type)) continue;
            ungroupedTypes.add(type);
        }
    }

    private ComponentGroup() {
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Nullable
    public ResourceLocation getIcon() {
        return this.icon;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public List<IProcedureType<?>> getMembers() {
        return this.members;
    }

    private void setup(JsonElement rootElement) {
        if (rootElement.isJsonObject()) {
            JsonObject root = (JsonObject)rootElement;
            this.processName(root.get("name"));
            this.processIcon(root.get("icon"));
            this.processTranslationKey(root.get("translation_key"));
            this.processMembers(root.get("members"));
        }
    }

    private void processName(JsonElement nameElement) {
        String name = nameElement.getAsString();
        this.registryName = new ResourceLocation(name);
    }

    private void processIcon(JsonElement iconElement) {
        if (iconElement != null) {
            String iconPath = iconElement.getAsString();
            this.icon = new ResourceLocation(iconPath);
        }
    }

    private void processTranslationKey(JsonElement translationKeyElement) {
        this.translationKey = translationKeyElement != null ? translationKeyElement.getAsString() : this.registryName.toString();
    }

    private void processMembers(JsonElement membersElement) {
        JsonArray members = membersElement.getAsJsonArray();
        for (JsonElement memberElement : members) {
            ResourceLocation member = new ResourceLocation(memberElement.getAsString());
            IProcedureType type = (IProcedureType)StevesFactoryManagerAPI.getProceduresRegistry().getValue(member);
            if (type == null || !GUIVisibility.isEnabled(type)) continue;
            this.members.add(type);
        }
    }

    private static /* synthetic */ int lambda$setupInternal$0(Object2IntMap orders, ComponentGroup group) {
        return orders.getOrDefault((Object)group.getRegistryName().toString(), 0);
    }
}

