/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.ui.manager.menu;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.world.World;
import vswe.stevesfactory.api.logic.IClientDataStorage;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.library.gui.layout.properties.HorizontalAlignment;
import vswe.stevesfactory.library.gui.layout.properties.Side;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.logic.procedure.ICraftingGrid;
import vswe.stevesfactory.ui.manager.editor.FlowComponent;
import vswe.stevesfactory.ui.manager.editor.Menu;
import vswe.stevesfactory.ui.manager.menu.ConfigurableSlot;

public class CraftingRecipeMenu<P extends IProcedure & IClientDataStorage>
extends Menu<P> {
    private IngredientSlot[] ingredients = new IngredientSlot[9];
    private ProductSlot product;
    private ICraftingRecipe recipe;

    public CraftingRecipeMenu() {
        for (int i = 0; i < this.ingredients.length; ++i) {
            this.ingredients[i] = new IngredientSlot(ItemStack.field_190927_a, i);
            this.addChildren(this.ingredients[i]);
        }
        this.product = new ProductSlot(ItemStack.field_190927_a);
        this.addChildren(this.product);
        this.reflow();
    }

    @Override
    public void onLinkFlowComponent(FlowComponent<P> flowComponent) {
        super.onLinkFlowComponent(flowComponent);
        Object procedure = this.getLinkedProcedure();
        for (IngredientSlot slot : this.ingredients) {
            slot.stack = ((ICraftingGrid)procedure).getIngredient(slot.slot);
        }
        this.updateRecipeProduct();
    }

    @Override
    public void reflow() {
        int x = 4;
        int y = HEADING_BOX.getPortionHeight() + 4;
        int i = 1;
        for (IngredientSlot slot : this.ingredients) {
            slot.setLocation(x, y);
            if (i % 3 == 0) {
                x = 4;
                y += slot.getWidth() + 4;
            } else {
                x += slot.getHeight() + 4;
            }
            ++i;
        }
        this.product.alignTo(this.ingredients[5], Side.RIGHT, HorizontalAlignment.CENTER);
        this.product.moveX(4);
    }

    @Override
    public String getHeadingText() {
        return I18n.func_135052_a((String)"menu.sfm.RecipeConfiguration", (Object[])new Object[0]);
    }

    @Override
    public List<String> populateErrors(List<String> errors) {
        if (this.recipe == null) {
            errors.add(I18n.func_135052_a((String)"error.sfm.CraftingProcedure.NoRecipe", (Object[])new Object[0]));
        } else if (this.recipe.func_192399_d()) {
            errors.add(I18n.func_135052_a((String)"error.sfm.CraftingProcedure.Dynamic", (Object[])new Object[0]));
        }
        return errors;
    }

    private void updateRecipeProduct() {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        CraftingInventory inventory = ((ICraftingGrid)this.getLinkedProcedure()).getInventory();
        Optional lookup = world.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)inventory, (World)world);
        this.recipe = lookup.orElse(null);
        ItemStack stack = lookup.map(r -> r.func_77572_b((IInventory)inventory)).orElse(ItemStack.field_190927_a);
        this.product.setStack(stack);
    }

    private void onSetIngredient(int slot, ItemStack ingredient) {
        Object procedure = this.getLinkedProcedure();
        ((ICraftingGrid)procedure).setIngredient(slot, ingredient);
        this.updateRecipeProduct();
    }

    private void onClearIngredients() {
        for (IngredientSlot slot : this.ingredients) {
            slot.setStack(ItemStack.field_190927_a);
        }
        this.product.setStack(ItemStack.field_190927_a);
    }

    public class ProductSlot
    extends ConfigurableSlot<IWidget> {
        public ProductSlot(ItemStack stack) {
            super(stack);
        }

        @Override
        protected boolean hasEditor() {
            return false;
        }

        @Override
        protected IWidget createEditor() {
            return null;
        }

        @Override
        protected void onLeftClick() {
        }

        @Override
        protected void onRightClick() {
            CraftingRecipeMenu.this.onClearIngredients();
        }
    }

    public class IngredientSlot
    extends ConfigurableSlot<IWidget> {
        public final int slot;

        public IngredientSlot(ItemStack stack, int slot) {
            super(stack);
            this.slot = slot;
        }

        @Override
        protected boolean hasEditor() {
            return false;
        }

        @Override
        protected IWidget createEditor() {
            return null;
        }

        @Override
        protected void onRightClick() {
            this.setStack(ItemStack.field_190927_a);
        }

        @Override
        protected void onSetStack() {
            CraftingRecipeMenu.this.onSetIngredient(this.slot, this.stack);
        }
    }
}

