/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.logic;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.logic.IProcedureType;

public class SimpleProcedureType<P extends IProcedure>
extends ForgeRegistryEntry<IProcedureType<?>>
implements IProcedureType<P> {
    private final Supplier<P> constructor;
    private final ResourceLocation icon;
    private String translationKey = null;

    public SimpleProcedureType(Function<IProcedureType<P>, P> constructor, ResourceLocation icon) {
        this.constructor = () -> (IProcedure)constructor.apply(this);
        this.icon = icon;
    }

    public SimpleProcedureType(Supplier<P> constructor, ResourceLocation icon) {
        this.constructor = constructor;
        this.icon = icon;
    }

    @Override
    public P createInstance() {
        return (P)((IProcedure)this.constructor.get());
    }

    @Override
    public P retrieveInstance(CompoundNBT tag) {
        IProcedure procedure = (IProcedure)this.constructor.get();
        procedure.deserialize(tag);
        return (P)procedure;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.icon;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = "logic." + this.getRegistryNameNonnull().toString().replace(':', '.');
        }
        return this.translationKey;
    }

    @Nonnull
    public ResourceLocation getRegistryNameNonnull() {
        ResourceLocation id = super.getRegistryName();
        Preconditions.checkState((id != null ? 1 : 0) != 0, (Object)("Procedure type " + this + " does not have a registry name!"));
        return id;
    }
}

