/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.library.gui.layout;

import com.google.common.base.Preconditions;
import java.awt.Dimension;
import java.util.List;
import vswe.stevesfactory.library.gui.layout.properties.BoxSizing;
import vswe.stevesfactory.library.gui.widget.IWidget;
import vswe.stevesfactory.utils.Utils;

public final class StrictTableLayout {
    public GrowDirection stackDirection;
    public GrowDirection overflowDirection;
    public int componentMargin;

    private static boolean isCompletelyInside(int x, int y, int width, int height, int mx, int my) {
        return Utils.isInside(x, y, mx, my) && Utils.isInside(x, y + height, mx, my) && Utils.isInside(x + width, y + height, mx, my) && Utils.isInside(x + width, y, mx, my);
    }

    public StrictTableLayout(GrowDirection stackDirection, GrowDirection overflowDirection, int componentMargin) {
        this.stackDirection = stackDirection;
        this.overflowDirection = overflowDirection;
        this.componentMargin = componentMargin;
    }

    public <T extends IWidget> List<T> reflow(Dimension bounds, List<T> widgets) {
        Preconditions.checkArgument((boolean)this.isWidgetDimensionsIdentical(widgets));
        int nextX = this.componentMargin;
        int nextY = this.componentMargin;
        int headX = nextX;
        int headY = nextY;
        for (IWidget widget : widgets) {
            if (!BoxSizing.shouldIncludeWidget(widget)) continue;
            widget.setLocation(nextX, nextY);
            int width = widget.getWidth();
            int height = widget.getHeight();
            if (StrictTableLayout.isCompletelyInside(nextX = this.stackDirection.computeNextX(nextX, width, this.componentMargin), nextY = this.stackDirection.computeNextY(nextY, height, this.componentMargin), width, height, bounds.width, bounds.height)) continue;
            nextX = headX = this.overflowDirection.computeNextX(headX, width, this.componentMargin);
            nextY = headY = this.overflowDirection.computeNextY(headY, height, this.componentMargin);
        }
        return widgets;
    }

    private boolean isWidgetDimensionsIdentical(List<? extends IWidget> widgets) {
        if (widgets.isEmpty()) {
            return true;
        }
        IWidget first = widgets.get(0);
        int commonWidth = first.getWidth();
        int commonHeight = first.getHeight();
        for (IWidget iWidget : widgets) {
            if (commonWidth == iWidget.getWidth() && commonHeight == iWidget.getHeight()) continue;
            return false;
        }
        return true;
    }

    public static enum GrowDirection {
        UP{

            @Override
            public int computeNextX(int originalX, int width, int margin) {
                return originalX;
            }

            @Override
            public int computeNextY(int originalY, int height, int margin) {
                return originalY - margin - height;
            }
        }
        ,
        DOWN{

            @Override
            public int computeNextX(int originalX, int width, int margin) {
                return originalX;
            }

            @Override
            public int computeNextY(int originalY, int height, int margin) {
                return originalY + height + margin;
            }
        }
        ,
        LEFT{

            @Override
            public int computeNextX(int originalX, int width, int margin) {
                return originalX - margin - width;
            }

            @Override
            public int computeNextY(int originalY, int height, int margin) {
                return originalY;
            }
        }
        ,
        RIGHT{

            @Override
            public int computeNextX(int originalX, int width, int margin) {
                return originalX + width + margin;
            }

            @Override
            public int computeNextY(int originalY, int height, int margin) {
                return originalY;
            }
        };


        public abstract int computeNextX(int var1, int var2, int var3);

        public abstract int computeNextY(int var1, int var2, int var3);
    }
}

