/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import vswe.stevesfactory.blocks.ItemIntakeTileEntity;
import vswe.stevesfactory.ui.intake.ItemIntakeContainer;
import vswe.stevesfactory.utils.Utils;

public class ItemIntakeBlock
extends Block {
    public static final EnumProperty<ItemIntakeTileEntity.Mode> MODE_PROPERTY = EnumProperty.func_177709_a((String)"mode", ItemIntakeTileEntity.Mode.class);
    private Supplier<TileEntity> tileEntityFactory;

    public ItemIntakeBlock(Supplier<TileEntity> tileEntityFactory, Block.Properties properties) {
        super(properties);
        this.tileEntityFactory = tileEntityFactory;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ItemIntakeTileEntity) {
            ItemIntakeTileEntity intake = (ItemIntakeTileEntity)tile;
            ItemIntakeContainer.openGUI((ServerPlayerEntity)player, intake);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState replacedBy, boolean moved) {
        if (state.func_177230_c() != replacedBy.func_177230_c()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof ItemIntakeTileEntity) {
                tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inventory -> Utils.dropInventoryItems(world, pos, inventory));
            }
            super.func_196243_a(state, world, pos, replacedBy, moved);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)context.func_196010_d().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H, MODE_PROPERTY});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.tileEntityFactory.get();
    }
}

