/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.logging.log4j.Logger;
import vswe.stevesfactory.Config;
import vswe.stevesfactory.StevesFactoryManager;
import vswe.stevesfactory.api.StevesFactoryManagerAPI;
import vswe.stevesfactory.api.logic.Connection;
import vswe.stevesfactory.api.logic.IProcedure;
import vswe.stevesfactory.api.logic.IProcedureType;
import vswe.stevesfactory.api.logic.ProcedureGraph;
import vswe.stevesfactory.api.network.ICable;
import vswe.stevesfactory.api.network.INetworkController;
import vswe.stevesfactory.network.NetworkHandler;
import vswe.stevesfactory.network.PacketSyncProcedureGraph;
import vswe.stevesfactory.setup.ModBlocks;
import vswe.stevesfactory.ui.manager.FactoryManagerContainer;
import vswe.stevesfactory.utils.IOHelper;
import vswe.stevesfactory.utils.NetworkHelper;
import vswe.stevesfactory.utils.Utils;

public class FactoryManagerTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider,
INetworkController,
ICable {
    private Set<BlockPos> connectedCables = new HashSet<BlockPos>();
    private Map<String, Multiset<BlockPos>> linkedInventories = new HashMap<String, Multiset<BlockPos>>();
    private ProcedureGraph graph = ProcedureGraph.create();
    private int ticks;

    public FactoryManagerTileEntity() {
        super(ModBlocks.factoryManagerTileEntity);
    }

    public void onLoad() {
        super.onLoad();
        this.ticks = 0;
    }

    public void func_73660_a() {
        assert (this.field_145850_b != null);
        if (!this.field_145850_b.field_72995_K) {
            this.graph.tick(this);
            if (this.ticks == 0) {
                this.reload();
                this.ticks = (Integer)Config.COMMON.rescanInterval.get();
            } else {
                --this.ticks;
            }
        }
    }

    private void reload() {
        this.search();
        this.func_70296_d();
    }

    public void activate(PlayerEntity player) {
        assert (this.field_145850_b != null);
        Preconditions.checkState((!this.field_145850_b.field_72995_K ? 1 : 0) != 0);
        StevesFactoryManager.logger.trace("Player {} activated a factory manager at {}", (Object)player, (Object)this.field_174879_c);
        this.search();
        this.func_70296_d();
        FactoryManagerContainer.openGUI((ServerPlayerEntity)player, this);
    }

    private void search() {
        StevesFactoryManager.logger.trace("Triggered searching process on a factory manager at {}", (Object)this.field_174879_c);
        this.connectedCables.clear();
        this.linkedInventories.clear();
        this.addCableToNetwork(this, this.field_174879_c);
        this.search(this.field_174879_c, 0);
    }

    private void search(BlockPos center, int depth) {
        if (depth > (Integer)Config.COMMON.maxSearchDepth.get()) {
            return;
        }
        assert (this.field_145850_b != null);
        StevesFactoryManager.logger.trace("Searching at cable {}", (Object)center);
        for (Direction direction : Utils.DIRECTIONS) {
            ICable cable;
            BlockPos neighbor = center.func_177972_a(direction);
            TileEntity tile = this.field_145850_b.func_175625_s(neighbor);
            if (!(tile instanceof ICable) || this.connectedCables.contains(neighbor) || !(cable = (ICable)tile).isCable()) continue;
            this.addCableToNetwork(cable, neighbor);
            this.search(neighbor, depth + 1);
        }
    }

    private void addCableToNetwork(ICable cable, BlockPos pos) {
        cable.addLinksFor(this);
        this.connectedCables.add(pos);
    }

    public void dump() {
        assert (this.field_145850_b != null);
        Logger logger = StevesFactoryManager.logger;
        logger.debug("======== Dumping Factory Manager at {} ========", (Object)this.field_174879_c);
        logger.debug("Connected cables:");
        for (BlockPos blockPos : this.connectedCables) {
            if (this.field_174879_c.equals((Object)blockPos)) {
                logger.debug("    This controller: {}", (Object)this);
                continue;
            }
            logger.debug("    {}: {}", (Object)blockPos, (Object)this.field_145850_b.func_175625_s(blockPos));
        }
        for (Map.Entry entry : this.linkedInventories.entrySet()) {
            String capName = (String)entry.getKey();
            Multiset set = (Multiset)entry.getValue();
            logger.debug("Linked inventories ({}):", (Object)capName);
            for (BlockPos pos : set) {
                logger.debug("    {}: {}", (Object)pos, (Object)this.field_145850_b.func_175625_s(pos));
            }
        }
        logger.debug("======== Finished dumping Factory Manager ========");
    }

    @Override
    public DimensionType getDimension() {
        assert (this.field_145850_b != null);
        return this.field_145850_b.func_201675_m().func_186058_p();
    }

    @Override
    public Set<BlockPos> getConnectedCables() {
        return this.connectedCables;
    }

    @Override
    public void removeCable(BlockPos cable) {
        this.func_70296_d();
        assert (this.field_145850_b != null);
        this.connectedCables.remove(cable);
    }

    public <T> Multiset<BlockPos> getInventoryMultiset(@Nullable Capability<T> cap) {
        String capName = cap == null ? "" : cap.getName();
        Multiset<BlockPos> multiset = this.linkedInventories.get(capName);
        if (multiset == null) {
            HashMultiset newSet = HashMultiset.create();
            this.linkedInventories.put(capName, (Multiset<BlockPos>)newSet);
            return newSet;
        }
        return multiset;
    }

    @Override
    public <T> Set<BlockPos> getLinkedInventories(@Nullable Capability<T> cap) {
        return this.getInventoryMultiset(cap).elementSet();
    }

    @Override
    public <T> boolean addLink(Capability<T> cap, BlockPos pos) {
        this.func_70296_d();
        StevesFactoryManager.logger.trace("Added link");
        return this.getInventoryMultiset(cap).add((Object)pos);
    }

    @Override
    public <T> boolean addLinks(Capability<T> cap, Collection<BlockPos> poses) {
        this.func_70296_d();
        StevesFactoryManager.logger.trace("Added {} links", (Object)poses.size());
        return this.getInventoryMultiset(cap).addAll(poses);
    }

    @Override
    public void removeAllLinks() {
        this.func_70296_d();
        this.linkedInventories.clear();
    }

    @Override
    public ProcedureGraph getPGraph() {
        return this.graph;
    }

    public void setPGraph(ProcedureGraph graph) {
        this.graph.invalidateContent();
        this.graph = graph;
    }

    @Override
    public <T> boolean removeLink(Capability<T> cap, BlockPos pos) {
        this.func_70296_d();
        StevesFactoryManager.logger.trace("Removed link");
        return this.getInventoryMultiset(cap).remove((Object)pos);
    }

    @Override
    public void addLinksFor(INetworkController controller) {
        this.func_70296_d();
        NetworkHelper.updateLinksFor(controller, this);
    }

    @Override
    public boolean isValid() {
        return !this.field_145846_f;
    }

    @Override
    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    @Override
    @Nullable
    public World getControllerWorld() {
        return this.field_145850_b;
    }

    @Override
    public boolean isCable() {
        return true;
    }

    @Override
    public void sync() {
        assert (this.field_145850_b != null);
        if (this.field_145850_b.field_72995_K) {
            NetworkHandler.sendToServer(new PacketSyncProcedureGraph(this.getDimension(), this.getPosition(), this.graph));
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(CompoundNBT compound) {
        StevesFactoryManager.logger.trace("Restoring data from NBT {}", (Object)compound);
        super.func_145839_a(compound);
        this.readCustom(compound);
    }

    public void readCustom(CompoundNBT compound) {
        this.connectedCables.clear();
        IOHelper.readBlockPoses(compound.func_150295_c("ConnectedCables", 10), this.connectedCables);
        this.linkedInventories.clear();
        ListNBT serializedInventories = compound.func_150295_c("LinkedInventories", 10);
        for (int i = 0; i < serializedInventories.size(); ++i) {
            CompoundNBT element = serializedInventories.func_150305_b(i);
            ListNBT serializedPoses = element.func_150295_c("Positions", 10);
            HashMultiset set = HashMultiset.create();
            for (int j = 0; j < serializedPoses.size(); ++j) {
                set.add((Object)NBTUtil.func_186861_c((CompoundNBT)serializedPoses.func_150305_b(j)));
            }
            String name = element.func_74779_i("Name");
            this.linkedInventories.put(name, (Multiset<BlockPos>)set);
        }
        int format = compound.func_74762_e("FormatVer");
        switch (format) {
            case 0: {
                this.setPGraph(ProcedureGraph.create());
                ListNBT graphNBT = compound.func_150295_c("CommandGraphs", 10);
                for (int i = 0; i < graphNBT.size(); ++i) {
                    CompoundNBT tag = graphNBT.func_150305_b(i);
                    ListNBT nodesNBT = tag.func_150295_c("Nodes", 10);
                    Int2ObjectOpenHashMap nodes = new Int2ObjectOpenHashMap();
                    for (int j = 0; j < nodesNBT.size(); ++j) {
                        CompoundNBT nodeNBT = nodesNBT.func_150305_b(j);
                        int id = nodeNBT.func_74762_e("ID");
                        CompoundNBT dataNBT = nodeNBT.func_74775_l("NodeData");
                        ResourceLocation loc = new ResourceLocation(dataNBT.func_74779_i("ID"));
                        IProcedureType p = (IProcedureType)StevesFactoryManagerAPI.getProceduresRegistry().getValue(loc);
                        Object node = Objects.requireNonNull(p).retrieveInstance(dataNBT);
                        nodes.put(id, node);
                        this.graph.addProcedure((IProcedure)node);
                    }
                    ListNBT connectionNBT = tag.func_150295_c("Connections", 10);
                    for (int j = 0; j < connectionNBT.size(); ++j) {
                        CompoundNBT nbt = connectionNBT.func_150305_b(j);
                        IProcedure from = (IProcedure)nodes.get(nbt.func_74762_e("From"));
                        int fromOut = nbt.func_74762_e("FromOut");
                        IProcedure to = (IProcedure)nodes.get(nbt.func_74762_e("To"));
                        int toIn = nbt.func_74762_e("ToIn");
                        Connection.create(from, fromOut, to, toIn);
                    }
                }
                return;
            }
        }
        this.graph.deserialize(compound.func_74775_l("Procedures"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        StevesFactoryManager.logger.trace("Writing data into NBT ({})", (Object)this.field_174879_c);
        this.writeCustom(compound);
        return super.func_189515_b(compound);
    }

    public CompoundNBT writeCustom(CompoundNBT compound) {
        compound.func_74768_a("FormatVer", 1);
        compound.func_218657_a("ConnectedCables", (INBT)IOHelper.writeBlockPoses(this.connectedCables));
        ListNBT serializedInventories = new ListNBT();
        for (Map.Entry<String, Multiset<BlockPos>> entry : this.linkedInventories.entrySet()) {
            String capName = entry.getKey();
            Multiset<BlockPos> set = entry.getValue();
            ListNBT serializedPoses = new ListNBT();
            for (BlockPos pos : set) {
                serializedPoses.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
            }
            CompoundNBT element = new CompoundNBT();
            element.func_74778_a("Name", capName);
            element.func_218657_a("Positions", (INBT)serializedPoses);
            serializedInventories.add((Object)element);
        }
        compound.func_218657_a("LinkedInventories", (INBT)serializedInventories);
        compound.func_218657_a("Procedures", (INBT)this.graph.serialize());
        return compound;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("gui.sfm.Title.FactoryManager", new Object[0]);
    }

    public Container createMenu(int i, PlayerInventory inv, PlayerEntity player) {
        return new FactoryManagerContainer(i, this);
    }
}

