/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.blocks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import vswe.stevesfactory.setup.ModBlocks;

public class BlockInteractorTileEntity
extends TileEntity
implements IItemHandler {
    public static final int UNREADY = 0;
    public static final int READY_SIMULATE = 1;
    public static final int READY_PERFORMED = 2;
    private LazyOptional<IItemHandler> itemHandlerCap = LazyOptional.of(() -> this);
    private int state = 0;
    private long lastUpdateGT = -1L;
    private List<ItemStack> droppedItems = null;
    private int readerIndex = -1;

    public BlockInteractorTileEntity() {
        super(ModBlocks.blockInteractorTileEntity);
    }

    private boolean isUnready() {
        return this.state == 0;
    }

    private void breakFrontBlock(boolean remove) {
        if (this.field_145850_b == null) {
            this.droppedItems = ImmutableList.of();
            this.readerIndex = -1;
            return;
        }
        if (this.state != 2 && this.field_145850_b.func_82737_E() != this.lastUpdateGT) {
            this.lastUpdateGT = this.field_145850_b.func_82737_E();
            this.state = 0;
        }
        switch (this.state) {
            case 0: {
                Direction facing = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
                BlockPos neighborPos = this.field_174879_c.func_177972_a(facing);
                BlockState neighbor = this.field_145850_b.func_180495_p(neighborPos);
                if (neighbor.isAir((IBlockReader)this.field_145850_b, neighborPos)) {
                    return;
                }
                this.droppedItems = Block.func_220070_a((BlockState)neighbor, (ServerWorld)((ServerWorld)this.field_145850_b), (BlockPos)neighborPos, (TileEntity)this.field_145850_b.func_175625_s(neighborPos));
                this.readerIndex = this.droppedItems.size() - 1;
                if (remove) {
                    this.field_145850_b.func_217377_a(neighborPos, false);
                    this.state = 2;
                    break;
                }
                this.state = 1;
                break;
            }
            case 1: {
                if (!remove) break;
                Direction facing = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
                BlockPos neighborPos = this.field_174879_c.func_177972_a(facing);
                this.field_145850_b.func_217377_a(neighborPos, false);
                this.state = 2;
                break;
            }
        }
    }

    private ItemStack getNextItem(boolean remove) {
        this.breakFrontBlock(remove);
        if (this.isUnready()) {
            return ItemStack.field_190927_a;
        }
        return this.droppedItems.get(this.readerIndex);
    }

    private void advance() {
        --this.readerIndex;
        if (this.readerIndex < 0) {
            this.state = 0;
        }
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (slot != 0) {
            return ItemStack.field_190927_a;
        }
        return this.getNextItem(false);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        BlockState state;
        if (slot != 0) {
            throw new IndexOutOfBoundsException("Slot index " + slot + " is not in range of [0,0]!");
        }
        if (this.field_145850_b == null || !(this.field_145850_b instanceof ServerWorld)) {
            return stack;
        }
        Item item = stack.func_77973_b();
        Direction facing = (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
        BlockPos neighborPos = this.field_174879_c.func_177972_a(facing);
        BlockState neighbor = this.field_145850_b.func_180495_p(neighborPos);
        FakePlayer fake = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_145850_b));
        BlockRayTraceResult rayTraceResult = this.field_145850_b.func_217299_a(new RayTraceContext(new Vec3d((Vec3i)this.field_174879_c), new Vec3d((Vec3i)neighborPos), RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)fake));
        BlockItemUseContext ctx = new BlockItemUseContext(new ItemUseContext((PlayerEntity)fake, Hand.MAIN_HAND, rayTraceResult));
        boolean replaceable = neighbor.func_196953_a(ctx);
        boolean placeable = item instanceof BlockItem;
        if (replaceable && placeable && (state = ((BlockItem)item).func_179223_d().func_196258_a(ctx)) != null && state.func_196955_c((IWorldReader)this.field_145850_b, neighborPos)) {
            if (!simulate) {
                this.field_145850_b.func_175656_a(neighborPos, state);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot != 0) {
            throw new IndexOutOfBoundsException("Slot index " + slot + " is not in range of [0,0]!");
        }
        if (this.field_145850_b == null || !(this.field_145850_b instanceof ServerWorld)) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            ItemStack next = this.getNextItem(false);
            if (next.func_190926_b()) {
                return next;
            }
            ItemStack result = next.func_77946_l();
            result.func_190920_e(Math.min(result.func_190916_E(), amount));
            return result;
        }
        ItemStack next = this.getNextItem(true);
        if (next.func_190926_b()) {
            return next;
        }
        int difference = next.func_190916_E() - amount;
        if (difference > 0) {
            next.func_190918_g(amount);
            return ItemHandlerHelper.copyStackWithSize((ItemStack)next, (int)amount);
        }
        this.advance();
        return next;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return slot == 0;
    }

    public void dropItems() {
        if (this.state == 2) {
            for (ItemStack item : this.droppedItems) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)item);
            }
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.state = compound.func_74762_e("State");
        this.readerIndex = compound.func_74762_e("ReaderIdx");
        this.droppedItems.clear();
        ListNBT serializedItems = compound.func_150295_c("DroppedItems", 10);
        for (int i = 0; i < serializedItems.size(); ++i) {
            this.droppedItems.add(ItemStack.func_199557_a((CompoundNBT)compound));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("State", this.state);
        compound.func_74768_a("ReaderIdx", this.readerIndex);
        ListNBT serializedItems = new ListNBT();
        if (this.droppedItems != null) {
            for (ItemStack item : this.droppedItems) {
                serializedItems.add((Object)item.func_77955_b(new CompoundNBT()));
            }
        }
        compound.func_218657_a("DroppedItems", (INBT)serializedItems);
        return super.func_189515_b(compound);
    }
}

