/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.progress;

import com.valkyrieofnight.vlib.core.ui.client.renderer.RenderUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDrawTooltip;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementUpdate;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.GuiUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.ProgressionDirection;
import com.valkyrieofnight.vlib.core.util.lambda.Provider;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;
import com.valkyrieofnight.vlib.core.util.tooltip.QuickTooltips;
import net.minecraft.nbt.CompoundNBT;

public abstract class AbstractProgressBarElement
extends VLElement
implements IElementDraw,
IElementUpdate,
IElementDrawTooltip,
IElementThemeListener {
    protected int width = this.width;
    protected int height = this.height;
    protected boolean drawToolTip = true;
    private float scale;
    protected ProgressionDirection barDirection;
    private Provider<Float> scaleProvider;
    protected QuickTooltips.List tooltipList;

    public AbstractProgressBarElement(String id, ProgressionDirection barDirection, Provider<Float> scaleProvider) {
        super(id);
        this.barDirection = barDirection;
        this.scaleProvider = scaleProvider;
    }

    @Override
    public int getSizeX() {
        return this.width;
    }

    @Override
    public int getSizeY() {
        return this.height;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        RenderUtils.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderBar(mouseX, mouseY, partialTicks, this.scale);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
    }

    @Override
    public void update() {
        this.scale = MathUtil.clamp(this.scaleProvider.request().floatValue(), 0.0f, 1.0f);
    }

    @Override
    public void drawTooltips(int mouseX, int mouseY) {
        if (!this.drawToolTip) {
            return;
        }
        if (this.withinBoxAndGui(mouseX, mouseY, this.getActualX(), this.getActualY(), this.getSizeX(), this.getSizeY())) {
            GuiUtils.drawTooltipsList(this.getContainer(), mouseX, mouseY, this.tooltipList.build());
        }
    }

    public void setToolTips(QuickTooltips.List list) {
        this.tooltipList = list;
    }

    protected abstract void renderBar(int var1, int var2, float var3, float var4);

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return nbt;
    }
}

