/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.base;

import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.obj.tileentity.base.TickCounter;
import com.valkyrieofnight.vlib.core.util.lambda.Action;
import com.valkyrieofnight.vlib.core.util.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.lambda.Function1a;
import com.valkyrieofnight.vlib.core.util.lambda.Provider;
import net.minecraft.nbt.CompoundNBT;

public class MultiTicker
implements INBTSerializer {
    private TickCounter counter = new TickCounter();
    private Provider<Boolean> canStartPrcess;
    private Function1a<Integer, Integer> checkAndValidateProcessable;
    private Provider<Boolean> canCompleteProcess;
    private Action onStartProcess;
    private Action1a<Integer> onProcessTicks;
    private Action onIdleTick;
    private Action onComplete;
    private Provider<Integer> getMaxTickRate;
    private Provider<Integer> getProcessDuration;

    public void tick() {
        if (this.counter.hasStarted() && !this.counter.isComplete()) {
            int ticks = this.counter.clampTicks(this.getMaxTickRate.request());
            if ((ticks = this.checkAndValidateProcessable.execute(ticks).intValue()) > 0) {
                this.onProcessTicks.execute(ticks);
                this.counter.tick(ticks);
            } else {
                this.onIdleTick.execute();
            }
        }
        if (!this.counter.hasStarted()) {
            this.startNewProcess();
        } else if (this.counter.isComplete() && this.canCompleteProcess.request().booleanValue()) {
            this.onComplete.execute();
            this.counter.reset(0);
        }
    }

    private void startNewProcess() {
        if (this.canStartPrcess.request().booleanValue()) {
            this.counter.reset(this.getProcessDuration.request());
            this.onStartProcess.execute();
            this.counter.start();
        }
    }

    public boolean hasStarted() {
        return this.counter.hasStarted();
    }

    public int getCurrentDuration() {
        return this.counter.getDuration();
    }

    public int getCurrentProgress() {
        return this.counter.getProgress();
    }

    @Override
    public CompoundNBT serializeNBT() {
        return this.counter.serializeNBT();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.counter.deserializeNBT(nbt);
    }

    public static class Builder {
        private Provider<Boolean> canStartProcess;
        private Function1a<Integer, Integer> checkAndValidateProcessable;
        private Provider<Boolean> canCompleteProcess;
        private Action onStartProcess;
        private Action1a<Integer> onProcessTicks;
        private Action onIdleTick;
        private Action onCompleteProcess;
        private Provider<Integer> getMaxTickRate;
        private Provider<Integer> getProcessDuration;

        public static Builder create() {
            return new Builder();
        }

        public Builder setCanStartProvider(Provider<Boolean> canStartProcessProvider) {
            this.canStartProcess = canStartProcessProvider;
            return this;
        }

        public Builder setCheckAndValidateProcessableProvider(Function1a<Integer, Integer> checkAndValidateProcessableProvider) {
            this.checkAndValidateProcessable = checkAndValidateProcessableProvider;
            return this;
        }

        public Builder setCanCompleteProcessProvider(Provider<Boolean> provider) {
            this.canCompleteProcess = provider;
            return this;
        }

        public Builder setOnStartProcessAction(Action action) {
            this.onStartProcess = action;
            return this;
        }

        public Builder setOnProcessTickAction(Action1a<Integer> action) {
            this.onProcessTicks = action;
            return this;
        }

        public Builder setOnIdleTickAction(Action action) {
            this.onIdleTick = action;
            return this;
        }

        public Builder setOnCompleteProcessAction(Action action) {
            this.onCompleteProcess = action;
            return this;
        }

        public Builder setGetMaxTickRateProvider(Provider<Integer> provider) {
            this.getMaxTickRate = provider;
            return this;
        }

        public Builder setGetProcessDurationProvider(Provider<Integer> provider) {
            this.getProcessDuration = provider;
            return this;
        }

        public MultiTicker build() {
            MultiTicker tracker = new MultiTicker();
            tracker.canStartPrcess = this.canStartProcess != null ? this.canStartProcess : () -> true;
            tracker.checkAndValidateProcessable = this.checkAndValidateProcessable != null ? this.checkAndValidateProcessable : amnt -> amnt;
            tracker.canCompleteProcess = this.canCompleteProcess != null ? this.canCompleteProcess : () -> true;
            tracker.onStartProcess = this.onStartProcess != null ? this.onStartProcess : () -> {};
            tracker.onProcessTicks = this.onProcessTicks != null ? this.onProcessTicks : amt -> {};
            tracker.onIdleTick = this.onIdleTick != null ? this.onIdleTick : () -> {};
            tracker.onComplete = this.onCompleteProcess != null ? this.onCompleteProcess : () -> {};
            tracker.getMaxTickRate = this.getMaxTickRate != null ? this.getMaxTickRate : () -> 1;
            if (this.getProcessDuration == null) {
                throw new NullPointerException("Process Duration cannot be null inside a TickTracker");
            }
            tracker.getProcessDuration = this.getProcessDuration;
            return tracker;
        }
    }
}

