/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.detail;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class Inventories {
    public static boolean areItemStacksIdentical(ItemStack a, ItemStack b) {
        return a.func_77973_b() == b.func_77973_b() && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemStacksDifferent(ItemStack a, ItemStack b) {
        return a.func_77973_b() != b.func_77973_b() || !ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static IItemHandler itemhandler(World world, BlockPos pos, @Nullable Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return null;
        }
        IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElse(null);
        if (ih != null) {
            return ih;
        }
        if (side != null && te instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)te, side);
        }
        if (te instanceof IInventory) {
            return new InvWrapper((IInventory)te);
        }
        return null;
    }

    public static ItemStack insert(IItemHandler inventory, ItemStack stack, boolean simulate) {
        return ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)stack, (boolean)simulate);
    }

    public static ItemStack insert(TileEntity te, @Nullable Direction side, ItemStack stack, boolean simulate) {
        if (te == null) {
            return stack;
        }
        IItemHandler hnd = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).orElse(null);
        if (hnd != null) {
            hnd = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        } else if (side != null && te instanceof ISidedInventory) {
            hnd = new SidedInvWrapper((ISidedInventory)te, side);
        } else if (te instanceof IInventory) {
            hnd = new InvWrapper((IInventory)te);
        }
        return hnd == null ? stack : ItemHandlerHelper.insertItemStacked((IItemHandler)hnd, (ItemStack)stack, (boolean)simulate);
    }

    public static ItemStack extract(IItemHandler inventory, @Nullable ItemStack match, int amount, boolean simulate) {
        if (inventory == null || amount <= 0) {
            return ItemStack.field_190927_a;
        }
        int max = inventory.getSlots();
        ItemStack out_stack = ItemStack.field_190927_a;
        for (int i = 0; i < max; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (out_stack.func_190926_b()) {
                if (match != null && Inventories.areItemStacksDifferent(stack, match)) continue;
                out_stack = inventory.extractItem(i, amount, simulate);
            } else if (Inventories.areItemStacksIdentical(stack, out_stack)) {
                ItemStack es = inventory.extractItem(i, amount - out_stack.func_190916_E(), simulate);
                out_stack.func_190917_f(es.func_190916_E());
            }
            if (out_stack.func_190916_E() >= amount) break;
        }
        return out_stack;
    }

    private static ItemStack checked(ItemStack stack) {
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
    }

    public static class InventoryRange
    implements IInventory {
        public final IInventory inventory;
        public final int offset;
        public final int size;

        public InventoryRange(IInventory inventory, int offset, int size) {
            this.inventory = inventory;
            this.offset = offset;
            this.size = size;
        }

        public void func_174888_l() {
            this.inventory.func_174888_l();
        }

        public int func_70302_i_() {
            return this.size;
        }

        public boolean func_191420_l() {
            for (int i = 0; i < this.size; ++i) {
                if (this.inventory.func_70301_a(this.offset + i).func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return this.inventory.func_70301_a(this.offset + index);
        }

        public ItemStack func_70298_a(int index, int count) {
            return this.inventory.func_70298_a(this.offset + index, count);
        }

        public ItemStack func_70304_b(int index) {
            return this.inventory.func_70304_b(this.offset + index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.inventory.func_70299_a(this.offset + index, stack);
        }

        public int func_70297_j_() {
            return this.inventory.func_70297_j_();
        }

        public void func_70296_d() {
            this.inventory.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return this.inventory.func_70300_a(player);
        }

        public void func_174889_b(PlayerEntity player) {
            this.inventory.func_174889_b(player);
        }

        public void func_174886_c(PlayerEntity player) {
            this.inventory.func_174886_c(player);
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return this.inventory.func_94041_b(this.offset + index, stack);
        }
    }

    public static class SlotRange {
        public final IInventory inventory;
        public final int start_slot;
        public final int end_slot;

        public SlotRange(IInventory inv, int start, int end) {
            this.inventory = inv;
            this.start_slot = start;
            this.end_slot = end;
        }

        public int stackMatchCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = this.start_slot; i < this.end_slot; ++i) {
                if (!Inventories.areItemStacksIdentical(ref_stack, this.inventory.func_70301_a(i))) continue;
                ++n;
            }
            return n;
        }

        public int totalMatchingItemCount(ItemStack ref_stack) {
            int n = 0;
            for (int i = this.start_slot; i < this.end_slot; ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (!Inventories.areItemStacksIdentical(ref_stack, stack)) continue;
                n += stack.func_190916_E();
            }
            return n;
        }

        public ItemStack insert(ItemStack stack_to_move, boolean only_fillup, int limit) {
            return this.insert(stack_to_move, only_fillup, limit, false, false);
        }

        public ItemStack insert(ItemStack stack_to_move, boolean only_fillup, int limit, boolean reverse, boolean force_group_stacks) {
            int nmax;
            ItemStack stack;
            int sno;
            int i;
            ItemStack mvstack = stack_to_move.func_77946_l();
            if (mvstack.func_190926_b() || this.start_slot < 0 || this.end_slot > this.inventory.func_70302_i_()) {
                return Inventories.checked(mvstack);
            }
            int limit_left = limit > 0 ? Math.min(limit, mvstack.func_77976_d()) : mvstack.func_77976_d();
            boolean[] matches = new boolean[this.end_slot];
            boolean[] empties = new boolean[this.end_slot];
            int num_matches = 0;
            for (i = this.start_slot; i < this.end_slot; ++i) {
                sno = reverse ? this.end_slot - 1 - i : i;
                stack = this.inventory.func_70301_a(sno);
                if (stack.func_190926_b() || !this.inventory.func_94041_b(sno, mvstack)) {
                    empties[sno] = true;
                    continue;
                }
                if (!Inventories.areItemStacksIdentical(stack, mvstack)) continue;
                matches[sno] = true;
                ++num_matches;
            }
            for (i = this.start_slot; i < this.end_slot; ++i) {
                int n = sno = reverse ? this.end_slot - 1 - i : i;
                if (empties[sno] || !matches[sno]) continue;
                stack = this.inventory.func_70301_a(sno);
                nmax = Math.min(limit_left, stack.func_77976_d() - stack.func_190916_E());
                if (mvstack.func_190916_E() <= nmax) {
                    stack.func_190920_e(stack.func_190916_E() + mvstack.func_190916_E());
                    this.inventory.func_70299_a(sno, stack);
                    return ItemStack.field_190927_a;
                }
                stack.func_190917_f(nmax);
                mvstack.func_190918_g(nmax);
                this.inventory.func_70299_a(sno, stack);
                limit_left -= nmax;
            }
            if (only_fillup) {
                return Inventories.checked(mvstack);
            }
            if (num_matches > 0 && (force_group_stacks || this.inventory instanceof PlayerInventory)) {
                int sno2;
                int i2;
                int insert_start = -1;
                int insert_end = -1;
                for (i2 = this.start_slot + 1; i2 < this.end_slot - 1; ++i2) {
                    int n = sno2 = reverse ? this.end_slot - 1 - i2 : i2;
                    if (insert_start < 0) {
                        if (!matches[sno2]) continue;
                        insert_start = sno2;
                        continue;
                    }
                    if (!matches[sno2]) continue;
                    insert_end = sno2;
                }
                for (i2 = insert_start; i2 < insert_end; ++i2) {
                    int n = sno2 = reverse ? this.end_slot - 1 - i2 : i2;
                    if (!empties[sno2]) continue;
                    int nmax2 = Math.min(limit_left, mvstack.func_190916_E());
                    ItemStack moved = mvstack.func_77946_l();
                    moved.func_190920_e(nmax2);
                    mvstack.func_190918_g(nmax2);
                    this.inventory.func_70299_a(sno2, moved);
                    return Inventories.checked(mvstack);
                }
                for (i = this.start_slot + 1; i < this.end_slot - 1; ++i) {
                    int ii;
                    int n = sno = reverse ? this.end_slot - 1 - i : i;
                    if (!matches[sno]) continue;
                    int n2 = empties[sno - 1] ? sno - 1 : (ii = empties[sno + 1] ? sno + 1 : -1);
                    if (ii < 0) continue;
                    nmax = Math.min(limit_left, mvstack.func_190916_E());
                    ItemStack moved = mvstack.func_77946_l();
                    moved.func_190920_e(nmax);
                    mvstack.func_190918_g(nmax);
                    this.inventory.func_70299_a(ii, moved);
                    return Inventories.checked(mvstack);
                }
            }
            for (i = this.start_slot; i < this.end_slot; ++i) {
                int n = sno = reverse ? this.end_slot - 1 - i : i;
                if (!empties[sno]) continue;
                int nmax3 = Math.min(limit_left, mvstack.func_190916_E());
                ItemStack placed = mvstack.func_77946_l();
                placed.func_190920_e(nmax3);
                mvstack.func_190918_g(nmax3);
                this.inventory.func_70299_a(sno, placed);
                return Inventories.checked(mvstack);
            }
            return Inventories.checked(mvstack);
        }

        public ItemStack extract(ItemStack request_stack) {
            ItemStack stack;
            if (request_stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            IInventory inventory = this.inventory;
            ArrayList<ItemStack> matches = new ArrayList<ItemStack>();
            for (int i = this.start_slot; i < this.end_slot; ++i) {
                ItemStack stack2 = inventory.func_70301_a(i);
                if (stack2.func_190926_b() || !Inventories.areItemStacksIdentical(stack2, request_stack)) continue;
                if (stack2.func_77942_o()) {
                    CompoundNBT nbt = stack2.func_77978_p();
                    int n = nbt.func_186856_d();
                    if (n > 0 && nbt.func_74764_b("Damage")) {
                        --n;
                    }
                    if (n > 0) continue;
                }
                matches.add(stack2);
            }
            matches.sort((a, b) -> Integer.compare(a.func_190916_E(), b.func_190916_E()));
            if (matches.isEmpty()) {
                return ItemStack.field_190927_a;
            }
            int n_left = request_stack.func_190916_E();
            ItemStack fetched_stack = ((ItemStack)matches.get(0)).func_77979_a(n_left);
            n_left -= fetched_stack.func_190916_E();
            for (int i = 1; i < matches.size() && n_left > 0; n_left -= stack.func_190916_E(), ++i) {
                stack = ((ItemStack)matches.get(i)).func_77979_a(n_left);
                fetched_stack.func_190917_f(stack.func_190916_E());
            }
            return Inventories.checked(fetched_stack);
        }
    }
}

