/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class SlabSliceBlock
extends StandardBlocks.WaterLoggable
implements StandardBlocks.IStandardBlock {
    public static final IntegerProperty PARTS = IntegerProperty.func_177719_a((String)"parts", (int)0, (int)14);
    protected static final VoxelShape[] AABBs = new VoxelShape[]{VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.125, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.375, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.625, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0)), VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0))};
    protected static final int[] num_slabs_contained_in_parts_ = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 7, 6, 5, 4, 3, 2, 1, 1};
    private static boolean with_pickup = false;

    public static void on_config(boolean direct_slab_pickup) {
        with_pickup = direct_slab_pickup;
    }

    public SlabSliceBlock(long config, Block.Properties builder) {
        super(config, builder);
    }

    protected boolean is_cube(BlockState state) {
        return (Integer)state.func_177229_b((IProperty)PARTS) == 7;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (!Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true)) {
            return;
        }
        if (with_pickup) {
            Auxiliaries.Tooltip.addInformation("engineersdecor.tooltip.slabpickup", "engineersdecor.tooltip.slabpickup", tooltip, flag, true);
        }
    }

    @Override
    public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
        return (this.config & 4L) != 0L ? StandardBlocks.IStandardBlock.RenderTypeHint.TRANSLUCENT : StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
    }

    @Override
    public boolean func_181623_g() {
        return false;
    }

    public boolean func_220067_a(BlockState state, IBlockReader world, BlockPos pos, EntityType<?> entityType) {
        return false;
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader source, BlockPos pos, ISelectionContext selectionContext) {
        return AABBs[(Integer)state.func_177229_b((IProperty)PARTS) & 0xF];
    }

    @Override
    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.func_220053_a(state, world, pos, selectionContext);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{PARTS});
    }

    @Override
    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        BlockState state = context.func_195991_k().func_180495_p(pos);
        if (state.func_177230_c() == this) {
            int parts = (Integer)state.func_177229_b((IProperty)PARTS);
            if (parts == 7) {
                return null;
            }
            if ((parts += parts < 7 ? 1 : -1) == 7) {
                state = (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false));
            }
            return (BlockState)state.func_206870_a((IProperty)PARTS, (Comparable)Integer.valueOf(parts));
        }
        Direction face = context.func_196000_l();
        BlockState placement_state = super.func_196258_a(context);
        if (face == Direction.UP) {
            return (BlockState)placement_state.func_206870_a((IProperty)PARTS, (Comparable)Integer.valueOf(0));
        }
        if (face == Direction.DOWN) {
            return (BlockState)placement_state.func_206870_a((IProperty)PARTS, (Comparable)Integer.valueOf(14));
        }
        if (!face.func_176740_k().func_176722_c()) {
            return placement_state;
        }
        boolean isupper = context.func_221532_j().func_82617_b() - (double)context.func_195995_a().func_177956_o() > 0.5;
        return (BlockState)placement_state.func_206870_a((IProperty)PARTS, (Comparable)Integer.valueOf(isupper ? 14 : 0));
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        boolean isupper;
        if (context.func_195996_i().func_77973_b() != this.func_199767_j()) {
            return false;
        }
        if (!context.func_196012_c()) {
            return true;
        }
        Direction face = context.func_196000_l();
        int parts = (Integer)state.func_177229_b((IProperty)PARTS);
        if (parts == 7) {
            return false;
        }
        if (face == Direction.UP && parts < 7) {
            return true;
        }
        if (face == Direction.DOWN && parts > 7) {
            return true;
        }
        if (!face.func_176740_k().func_176722_c()) {
            return false;
        }
        boolean bl = isupper = context.func_221532_j().func_82617_b() - (double)context.func_195995_a().func_177956_o() > 0.5;
        return isupper ? parts == 0 : parts == 1;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state;
    }

    @Override
    public boolean hasDynamicDropList() {
        return true;
    }

    @Override
    public List<ItemStack> dropList(BlockState state, World world, BlockPos pos, TileEntity te, boolean explosion) {
        return new ArrayList<ItemStack>(Collections.singletonList(new ItemStack((IItemProvider)this.func_199767_j(), num_slabs_contained_in_parts_[(Integer)state.func_177229_b((IProperty)PARTS) & 0xF])));
    }

    public void func_196270_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (world.field_72995_K || !with_pickup) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (stack.func_190926_b() || Block.func_149634_a((Item)stack.func_77973_b()) != this) {
            return;
        }
        if (stack.func_190916_E() >= stack.func_77976_d()) {
            return;
        }
        Vec3d lv = player.func_70040_Z();
        Direction facing = Direction.func_176737_a((float)((float)lv.field_72450_a), (float)((float)lv.field_72448_b), (float)((float)lv.field_72449_c));
        if (facing != Direction.UP && facing != Direction.DOWN) {
            return;
        }
        if (state.func_177230_c() != this) {
            return;
        }
        int parts = (Integer)state.func_177229_b((IProperty)PARTS);
        if (facing == Direction.DOWN && parts <= 7) {
            if (parts > 0) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)PARTS, (Comparable)Integer.valueOf(parts - 1)), 3);
            } else {
                world.func_217377_a(pos, false);
            }
        } else if (facing == Direction.UP && parts >= 7) {
            if (parts < 14) {
                world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)PARTS, (Comparable)Integer.valueOf(parts + 1)), 3);
            } else {
                world.func_217377_a(pos, false);
            }
        } else {
            return;
        }
        if (!player.func_184812_l_()) {
            stack.func_190917_f(1);
            if (player.field_71071_by != null) {
                player.field_71071_by.func_70296_d();
            }
        }
        SoundType st = this.getSoundType(state, (IWorldReader)world, pos, null);
        world.func_184133_a(player, pos, st.func_185841_e(), SoundCategory.BLOCKS, (st.func_185843_a() + 1.0f) / 2.5f, 0.9f * st.func_185847_b());
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, BlockState state, IFluidState fluidState) {
        return (Integer)state.func_177229_b((IProperty)PARTS) == 14 ? false : super.func_204509_a(world, pos, state, fluidState);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, BlockState state, Fluid fluid) {
        return (Integer)state.func_177229_b((IProperty)PARTS) == 14 ? false : super.func_204510_a(world, pos, state, fluid);
    }
}

