/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.scythe;

import com.lothrazar.cyclic.base.PacketBase;
import com.lothrazar.cyclic.item.scythe.ScytheType;
import com.lothrazar.cyclic.util.UtilScythe;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketScythe
extends PacketBase {
    private BlockPos pos;
    private ScytheType type;
    private int radius;

    public PacketScythe() {
    }

    public PacketScythe(BlockPos mouseover, ScytheType t, int r) {
        this.pos = mouseover;
        this.type = t;
        this.radius = r;
    }

    public static void handle(PacketScythe message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.func_130014_f_();
            List<BlockPos> shape = ScytheType.getShape(message.pos, message.radius);
            for (BlockPos posCurrent : shape) {
                UtilScythe.harvestSingle(world, (PlayerEntity)player, posCurrent, message.type);
            }
        });
        message.done(ctx);
    }

    public static PacketScythe decode(PacketBuffer buf) {
        PacketScythe p = new PacketScythe(buf.func_179259_c(), ScytheType.values()[buf.readInt()], buf.readInt());
        return p;
    }

    public static void encode(PacketScythe msg, PacketBuffer buf) {
        buf.func_179255_a(msg.pos);
        buf.writeInt(msg.type.ordinal());
        buf.writeInt(msg.radius);
    }
}

