/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tank;

import com.lothrazar.cyclic.capability.FluidHandlerCapabilityStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemBlockTank
extends BlockItem {
    public ItemBlockTank(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        FluidStack fstack = ItemBlockTank.copyFluidFromStack(stack);
        return fstack != null && fstack.getAmount() > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        try {
            FluidStack fstack = ItemBlockTank.copyFluidFromStack(stack);
            float qty = fstack.getAmount();
            float ratio = qty / 64000.0f;
            return 1.0f - ratio;
        }
        catch (Throwable throwable) {
            return 1.0;
        }
    }

    public static FluidStack copyFluidFromStack(ItemStack stack) {
        if (stack.func_77978_p() != null) {
            FluidHandlerCapabilityStack handler = new FluidHandlerCapabilityStack(stack, 64000);
            FluidStack fstack = handler.getFluid();
            if (fstack == null) {
                return null;
            }
            return handler.getFluid();
        }
        return null;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 11393254;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        FluidStack fs;
        IFluidHandler storage = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
        if (storage != null && (fs = storage.getFluidInTank(0)) != null && !fs.isEmpty()) {
            TranslationTextComponent t = new TranslationTextComponent(fs.getDisplayName().func_150254_d() + " " + fs.getAmount() + "/" + storage.getTankCapacity(0), new Object[0]);
            t.func_211708_a(TextFormatting.GRAY);
            tooltip.add((ITextComponent)t);
            return;
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerCapabilityStack(stack, 64000);
    }
}

