/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.shapebuilder;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.shapebuilder.BuildStructureType;
import com.lothrazar.cyclic.block.shapebuilder.ContainerStructure;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilPlaceBlocks;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileStructure
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    public static int maxSize = 99;
    public static int maxHeight = 99;
    static final int MAX = 64000;
    static final int SLOT_BUILD = 0;
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);
    private BuildStructureType buildType = BuildStructureType.FACING;
    private int buildSize = 3;
    private int height = 2;
    private int shapeIndex = 0;
    private int timer;
    private static final int spotsSkippablePerTrigger = 50;

    public TileStructure() {
        super(BlockRegistry.Tiles.structure);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("energy")));
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        int t = tag.func_74762_e("buildType");
        this.buildType = BuildStructureType.values()[t];
        this.buildSize = tag.func_74762_e("buildSize");
        this.height = tag.func_74762_e("height");
        this.shapeIndex = tag.func_74762_e("shapeIndex");
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("buildType", this.buildType.ordinal());
        tag.func_74768_a("buildSize", this.buildSize);
        tag.func_74768_a("height", this.height);
        tag.func_74768_a("shapeIndex", this.shapeIndex);
        this.energy.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(64000, 64000);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(1);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerStructure(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case BUILDTYPE: {
                if (value >= BuildStructureType.values().length) {
                    value = 0;
                }
                this.buildType = BuildStructureType.values()[value];
                break;
            }
            case SIZE: {
                this.buildSize = value;
                break;
            }
            case HEIGHT: {
                if (value > maxHeight) {
                    value = maxHeight;
                }
                this.height = Math.max(1, value);
                break;
            }
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.renderParticles = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case TIMER: {
                return this.timer;
            }
            case BUILDTYPE: {
                return this.buildType.ordinal();
            }
            case SIZE: {
                return this.buildSize;
            }
            case HEIGHT: {
                return this.height;
            }
            case REDSTONE: {
                return this.getNeedsRedstone();
            }
            case RENDER: {
                return this.renderParticles;
            }
        }
        return super.getField(field);
    }

    public void func_73660_a() {
        IEnergyStorage en;
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        IItemHandler inv = (IItemHandler)this.inventory.orElse(null);
        if (inv == null) {
            return;
        }
        ItemStack stack = inv.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return;
        }
        Block stuff = Block.func_149634_a((Item)stack.func_77973_b());
        if (stuff == null) {
            return;
        }
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return;
        }
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        if ((en = (IEnergyStorage)this.energy.orElse(null)) == null) {
            return;
        }
        int repair = 10;
        BlockPos nextPos = shape.get(this.shapeIndex);
        for (int i = 0; i < 50 && en.getEnergyStored() >= 10; ++i) {
            if (!World.func_189509_E((BlockPos)nextPos) && this.field_145850_b.func_175623_d(nextPos)) {
                BlockState placeState = stuff.func_176223_P();
                if (this.field_145850_b.field_72995_K || !UtilPlaceBlocks.placeStateSafe(this.field_145850_b, null, nextPos, placeState)) break;
                this.incrementPosition(shape);
                stack.func_190918_g(1);
                en.extractEnergy(10, false);
                break;
            }
            nextPos = shape.get(this.shapeIndex);
            this.incrementPosition(shape);
        }
    }

    private void incrementPosition(List<BlockPos> shape) {
        if (shape == null || shape.size() == 0) {
            return;
        }
        int c = this.shapeIndex + 1;
        if (c < 0 || c >= shape.size()) {
            c = 0;
        }
        this.shapeIndex = c;
    }

    private BlockPos getPosTarget() {
        return this.func_174877_v();
    }

    public BlockPos getTargetFacing() {
        return this.getPosTarget().func_177967_a(this.getCurrentFacing(), this.buildSize + 1);
    }

    private Direction getCurrentFacing() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208157_J);
    }

    public List<BlockPos> getShape() {
        List<BlockPos> shape = new ArrayList<BlockPos>();
        switch (this.buildType) {
            case CIRCLE: {
                shape = UtilShape.circleHorizontal(this.getPosTarget(), this.getSize() * 2);
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case FACING: {
                shape = UtilShape.line(this.getPosTarget(), this.getCurrentFacing(), this.getSize());
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case SQUARE: {
                shape = UtilShape.squareHorizontalHollow(this.getPosTarget(), this.getSize());
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case SOLID: {
                shape = UtilShape.squareHorizontalFull(this.getTargetFacing(), this.getSize());
                shape = UtilShape.repeatShapeByHeight(shape, this.getHeight() - 1);
                break;
            }
            case SPHERE: {
                shape = UtilShape.sphere(this.getPosTarget(), this.getSize());
                break;
            }
            case DOME: {
                shape = UtilShape.sphereDome(this.getPosTarget(), this.getSize());
                break;
            }
            case CUP: {
                shape = UtilShape.sphereCup(this.getPosTarget().func_177981_b(this.getSize()), this.getSize());
                break;
            }
            case DIAGONAL: {
                shape = UtilShape.diagonal(this.getPosTarget(), this.getCurrentFacing(), this.getSize() * 2, true);
                break;
            }
            case PYRAMID: {
                shape = UtilShape.squarePyramid(this.getPosTarget(), this.getSize(), this.getHeight());
            }
        }
        return shape;
    }

    private int getHeight() {
        return this.height;
    }

    private int getSize() {
        return this.buildSize;
    }

    public static enum Fields {
        TIMER,
        BUILDTYPE,
        SIZE,
        HEIGHT,
        REDSTONE,
        RENDER;

    }
}

