/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.melter;

import com.lothrazar.cyclic.ConfigManager;
import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.melter.ContainerMelter;
import com.lothrazar.cyclic.block.melter.RecipeMelter;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.BlockRegistry;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileMelter
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    static final int MAX = 64000;
    public static final int CAPACITY = 64000;
    public static final int TRANSFER_FLUID_PER_TICK = 50;
    public FluidTankBase tank;
    private LazyOptional<IEnergyStorage> energy = LazyOptional.of(this::createEnergy);
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createHandler);
    private RecipeMelter currentRecipe;
    private int timer = 0;
    public static final int TIMER_FULL = 60;

    public TileMelter() {
        super(BlockRegistry.Tiles.melter);
        this.tank = new FluidTankBase(this, 64000, this.isFluidValid());
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.renderParticles = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.getNeedsRedstone();
            }
            case RENDER: {
                return this.renderParticles;
            }
        }
        return super.getField(field);
    }

    private IEnergyStorage createEnergy() {
        return new CustomEnergyStorage(64000, 64000);
    }

    private IItemHandler createHandler() {
        ItemStackHandler h = new ItemStackHandler(2);
        return h;
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerMelter(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Override
    public void func_145839_a(CompoundNBT tag) {
        CompoundNBT fluid = tag.func_74775_l("fluid");
        this.tank.readFromNBT(fluid);
        this.energy.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("energy")));
        this.inventory.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("inv")));
        this.timer = tag.func_74762_e("timer");
        super.func_145839_a(tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        this.energy.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        this.inventory.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("inv", (INBT)compound);
        });
        tag.func_74768_a("timer", this.timer);
        return super.func_189515_b(tag);
    }

    public boolean hasFastRenderer() {
        return true;
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> this.tank).cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energy.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public float getCapacity() {
        return 64000.0f;
    }

    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    public ItemStack getStackInputSlot(int slot) {
        IItemHandler inv = (IItemHandler)this.inventory.orElse(null);
        return inv == null ? ItemStack.field_190927_a : inv.getStackInSlot(slot);
    }

    private void findMatchingRecipe() {
        if (this.currentRecipe != null && this.currentRecipe.matches((TileEntityBase)this, this.field_145850_b)) {
            return;
        }
        this.currentRecipe = null;
        for (RecipeMelter rec : RecipeMelter.RECIPES) {
            if (!rec.matches((TileEntityBase)this, this.field_145850_b)) continue;
            this.currentRecipe = rec;
        }
    }

    public void func_73660_a() {
        IEnergyStorage en = (IEnergyStorage)this.energy.orElse(null);
        if (en == null) {
            return;
        }
        this.findMatchingRecipe();
        if (this.currentRecipe == null) {
            return;
        }
        --this.timer;
        if (this.timer < 0) {
            this.timer = 0;
        }
        int cost = (Integer)ConfigManager.MELTERPOWER.get();
        if (en.getEnergyStored() < cost) {
            return;
        }
        if (this.timer == 0 && this.tryProcessRecipe()) {
            this.timer = 60;
            en.extractEnergy(cost, false);
        }
    }

    private boolean tryProcessRecipe() {
        int test = this.tank.fill(this.currentRecipe.getRecipeFluid(), IFluidHandler.FluidAction.SIMULATE);
        if (test == this.currentRecipe.getRecipeFluid().getAmount()) {
            this.getStackInputSlot(0).func_190918_g(1);
            this.getStackInputSlot(1).func_190918_g(1);
            this.tank.fill(this.currentRecipe.getRecipeFluid(), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public static enum Fields {
        REDSTONE,
        TIMER,
        RENDER;

    }
}

