/*
 * Decompiled with CFR 0.152.
 */
package jeresources.profiling;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import jeresources.profiling.ChunkProfiler;
import jeresources.profiling.DummyWorld;
import jeresources.profiling.ProfiledDimensionData;
import jeresources.profiling.Profiler;
import net.minecraft.world.chunk.Chunk;

public class ProfilingExecutor {
    private final ExecutorService executor;
    private final Profiler profiler;

    public ProfilingExecutor(Profiler profiler) {
        this.profiler = profiler;
        int processors = Runtime.getRuntime().availableProcessors();
        this.executor = Executors.newFixedThreadPool(processors * 2);
    }

    public void addChunkProfiler(DummyWorld dummyWorld, List<Chunk> chunks) {
        int dimId = dummyWorld.func_201675_m().func_186058_p().func_186068_a();
        ProfiledDimensionData dimensionData = (ProfiledDimensionData)this.profiler.getAllDimensionData().get(dimId);
        this.execute(new ChunkProfiler(dummyWorld, chunks, dimensionData, this.profiler.getTimer(), this.profiler.getBlacklist()));
    }

    public void execute(Runnable runnable) {
        try {
            this.executor.execute(runnable);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    public void awaitTermination() {
        while (true) {
            try {
                while (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

