/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.endermail.gui;

import com.chaosthedude.endermail.EnderMail;
import com.chaosthedude.endermail.gui.container.LockerContainer;
import com.chaosthedude.endermail.network.ConfigureLockerPacket;
import com.chaosthedude.endermail.util.RenderUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.IHasContainer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LockerScreen
extends ContainerScreen<LockerContainer>
implements IHasContainer<LockerContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("endermail:textures/gui/locker.png");
    private final LockerContainer containerLocker;
    private final PlayerInventory playerInventory;
    private TextFieldWidget idTextField;
    private BlockPos lockerPos;
    private String lockerID;

    public LockerScreen(LockerContainer containerLocker, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)containerLocker, playerInventory, title);
        this.playerInventory = playerInventory;
        this.containerLocker = containerLocker;
        this.lockerPos = containerLocker.getLockerPos();
        this.lockerID = containerLocker.getLockerID();
        this.field_147000_g = 133;
    }

    protected void init() {
        super.init();
        this.setupTextFields();
    }

    public void tick() {
        super.tick();
        this.idTextField.func_146178_a();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.idTextField.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(I18n.func_135052_a((String)"block.endermail.locker", (Object[])new Object[0]), 8.0f, 6.0f, 0x404040);
        this.font.func_211126_b(I18n.func_135052_a((String)"string.endermail.id", (Object[])new Object[0]), 75.0f, 6.0f, 0x404040);
        this.font.func_211126_b(this.playerInventory.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    public void onClose() {
        if (!this.idTextField.func_146179_b().isEmpty() && !this.idTextField.func_146179_b().equals(this.lockerID)) {
            EnderMail.network.sendToServer((Object)new ConfigureLockerPacket(this.lockerPos, this.idTextField.func_146179_b()));
        }
        super.onClose();
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (par1 == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        if (par1 == 258) {
            boolean flag;
            boolean bl = flag = !LockerScreen.hasShiftDown();
            if (!this.changeFocus(flag)) {
                this.changeFocus(flag);
            }
            return true;
        }
        if (this.getFocused() != null && this.getFocused().keyPressed(par1, par2, par3)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)par1, (int)par2);
        if (!this.idTextField.isFocused() && this.minecraft.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        if (this.func_195363_d(par1, par2)) {
            return true;
        }
        if (this.field_147006_u != null && this.field_147006_u.func_75216_d()) {
            if (this.minecraft.field_71474_y.field_74322_I.isActiveAndMatches(mouseKey)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, 0, ClickType.CLONE);
                return true;
            }
            if (this.minecraft.field_71474_y.field_74316_C.isActiveAndMatches(mouseKey)) {
                this.func_184098_a(this.field_147006_u, this.field_147006_u.field_75222_d, LockerScreen.hasControlDown() ? 1 : 0, ClickType.THROW);
                return true;
            }
        } else if (this.minecraft.field_71474_y.field_74316_C.isActiveAndMatches(mouseKey)) {
            return true;
        }
        return false;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        RenderUtils.drawTexturedModalRect(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    private void setupTextFields() {
        this.children.clear();
        this.idTextField = new TextFieldWidget(this.font, (this.width - this.field_146999_f) / 2 + 75, (this.height - this.field_147000_g) / 2 + 20, 80, 18, "");
        this.idTextField.func_146180_a(this.containerLocker.getLockerID() != null ? this.containerLocker.getLockerID() : "");
        this.idTextField.func_146203_f(12);
        this.children.add(this.idTextField);
    }
}

