/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.compat;

import java.util.ArrayList;
import java.util.function.Predicate;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.apiimpl.items.ItemChannelSettings;
import mcjty.xnet.apiimpl.items.ItemConnectorSettings;
import mcjty.xnet.setup.Config;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang3.tuple.Pair;

public class RFToolsSupport {
    public static boolean isStorageScanner(TileEntity te) {
        return te instanceof IStorageScanner;
    }

    public static void tickStorageScanner(IControllerContext context, ItemConnectorSettings settings, TileEntity te, ItemChannelSettings channelSettings) {
        IStorageScanner scanner = (IStorageScanner)te;
        Predicate<ItemStack> extractMatcher = settings.getMatcher(context);
        Integer count = settings.getCount();
        int amount = 0;
        if (count != null && (amount = scanner.countItems(extractMatcher, true, count)) < count) {
            return;
        }
        int cnt = 0;
        switch (settings.getStackMode()) {
            case SINGLE: {
                cnt = 1;
                break;
            }
            case STACK: {
                cnt = 64;
                break;
            }
            case COUNT: {
                cnt = settings.getExtractAmount();
            }
        }
        ItemStack stack = scanner.requestItem(extractMatcher, true, cnt, true);
        if (!stack.func_190926_b()) {
            int toextract = stack.func_190916_E();
            if (count != null) {
                int canextract = amount - count;
                if (canextract <= 0) {
                    return;
                }
                if (canextract < toextract) {
                    toextract = canextract;
                    if (toextract <= 0) {
                        stack.func_190920_e(0);
                    } else {
                        stack.func_190920_e(toextract);
                    }
                }
            }
            ArrayList<Pair<SidedConsumer, ItemConnectorSettings>> inserted = new ArrayList<Pair<SidedConsumer, ItemConnectorSettings>>();
            int remaining = channelSettings.insertStackSimulate(inserted, context, stack);
            if (!inserted.isEmpty() && context.checkAndConsumeRF(((Integer)Config.controllerOperationRFT.get()).intValue())) {
                channelSettings.insertStackReal(context, inserted, scanner.requestItem(extractMatcher, false, toextract - remaining, true));
            }
        }
    }

    public static int countItems(TileEntity te, Predicate<ItemStack> matcher, int count) {
        IStorageScanner scanner = (IStorageScanner)te;
        return scanner.countItems(matcher, true, Integer.valueOf(count));
    }

    public static int countItems(TileEntity te, ItemStack stack, int count) {
        IStorageScanner scanner = (IStorageScanner)te;
        return scanner.countItems(stack, true, Integer.valueOf(count));
    }

    public static ItemStack insertItem(TileEntity te, ItemStack stack, boolean simulate) {
        IStorageScanner scanner = (IStorageScanner)te;
        return scanner.insertItem(stack, simulate);
    }
}

