/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.core.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;

public class JsonUtil {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();

    @Nonnull
    public static <T> T fromJson(@Nonnull TypeToken<T> token, @Nonnull File file, @Nonnull T def) {
        T ret = JsonUtil.fromJson(token, file);
        if (ret == null) {
            JsonUtil.toJson(def, token, file);
            ret = def;
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static <T> T fromJson(@Nonnull TypeToken<T> token, @Nonnull File file) {
        if (!file.exists()) {
            return null;
        }
        try (FileReader reader = new FileReader(file);){
            Object object = GSON.fromJson((Reader)reader, token.getType());
            return (T)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T fromJson(@Nonnull TypeToken<T> token, @Nonnull String json) {
        return (T)GSON.fromJson(json, token.getType());
    }

    public static <T> void toJson(@Nonnull T type, @Nonnull TypeToken<T> token, @Nonnull File file) {
        if (!file.exists()) {
            try {
                FileUtils.forceMkdirParent((File)file);
                file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(JsonUtil.getJson(type, token));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> String getJson(@Nonnull T type, @Nonnull TypeToken<T> token) {
        return GSON.toJson(type, token.getType());
    }
}

