/*
 * Decompiled with CFR 0.152.
 */
package info.tehnut.soulshardsrespawn.block;

import info.tehnut.soulshardsrespawn.SoulShards;
import info.tehnut.soulshardsrespawn.api.CageSpawnEvent;
import info.tehnut.soulshardsrespawn.api.IShardTier;
import info.tehnut.soulshardsrespawn.block.BlockSoulCage;
import info.tehnut.soulshardsrespawn.core.RegistrarSoulShards;
import info.tehnut.soulshardsrespawn.core.data.Binding;
import info.tehnut.soulshardsrespawn.item.ItemSoulShard;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntitySoulCage
extends TileEntity
implements ITickableTileEntity {
    private ItemStackHandler inventory = new SoulCageInventory();
    private int activeTime;
    private boolean active = false;

    public TileEntitySoulCage() {
        super(RegistrarSoulShards.SOUL_CAGE_TE);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ActionResult<Binding> result = this.canSpawn();
        if (result.func_188397_a() != ActionResultType.SUCCESS) {
            if (this.active) {
                this.setState(false);
                this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
            return;
        }
        if (!this.active) {
            this.setState(true);
            this.field_145850_b.func_195593_d(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
        ++this.activeTime;
        if (this.activeTime % ((Binding)result.func_188398_b()).getTier().getCooldown() == 0) {
            this.spawnEntities();
        }
    }

    private void spawnEntities() {
        Binding binding = this.getBinding();
        if (binding == null || binding.getBoundEntity() == null) {
            return;
        }
        EntityType entityEntry = (EntityType)ForgeRegistries.ENTITIES.getValue(binding.getBoundEntity());
        if (entityEntry == null) {
            return;
        }
        IShardTier tier = binding.getTier();
        block0: for (int i = 0; i < tier.getSpawnAmount(); ++i) {
            for (int attempts = 0; attempts < 5; ++attempts) {
                CageSpawnEvent event;
                LivingEntity entityLiving;
                double z;
                double y;
                double x = (double)this.func_174877_v().func_177958_n() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 4.0 + 0.5;
                BlockPos spawnAt = new BlockPos(x, y = (double)(this.func_174877_v().func_177956_o() + this.func_145831_w().field_73012_v.nextInt(3)), z = (double)this.func_174877_v().func_177952_p() + (this.func_145831_w().field_73012_v.nextDouble() - this.func_145831_w().field_73012_v.nextDouble()) * 4.0 + 0.5);
                if (spawnAt.equals((Object)this.func_174877_v())) {
                    spawnAt = new BlockPos(x, y + 1.0, z);
                }
                if ((entityLiving = (LivingEntity)entityEntry.func_200721_a(this.func_145831_w())) == null || binding.getTier().checkLight() && !this.canSpawnInLight(entityLiving, spawnAt)) continue;
                entityLiving.func_174828_a(spawnAt, this.func_145831_w().field_73012_v.nextFloat() * 360.0f, 0.0f);
                entityLiving.getPersistentData().func_74757_a("cageBorn", true);
                entityLiving.field_98038_p = true;
                if (!entityLiving.func_70089_S() || this.hasReachedSpawnCap(entityLiving) || !this.func_145831_w().func_226668_i_((Entity)entityLiving) || !SoulShards.CONFIG.getBalance().allowBossSpawns() && !entityLiving.func_184222_aU() || MinecraftForge.EVENT_BUS.post((Event)(event = new CageSpawnEvent(binding, this.inventory.getStackInSlot(0), entityLiving)))) continue;
                this.func_145831_w().func_217376_c((Entity)entityLiving);
                if (!(entityLiving instanceof MobEntity)) continue block0;
                ((MobEntity)entityLiving).func_213386_a((IWorld)this.func_145831_w(), this.func_145831_w().func_175649_E(spawnAt), SpawnReason.SPAWNER, null, null);
                continue block0;
            }
        }
    }

    private ActionResult<Binding> canSpawn() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() != RegistrarSoulShards.SOUL_CAGE) {
            return new ActionResult(ActionResultType.FAIL, null);
        }
        ItemStack shardStack = this.inventory.getStackInSlot(0);
        if (shardStack.func_190926_b() || !(shardStack.func_77973_b() instanceof ItemSoulShard)) {
            return new ActionResult(ActionResultType.FAIL, null);
        }
        Binding binding = this.getBinding();
        if (binding == null || binding.getBoundEntity() == null) {
            return new ActionResult(ActionResultType.FAIL, (Object)binding);
        }
        IShardTier tier = binding.getTier();
        if (tier.getSpawnAmount() == 0) {
            return new ActionResult(ActionResultType.FAIL, (Object)binding);
        }
        if (SoulShards.CONFIG.getBalance().requireOwnerOnline() && !this.ownerOnline()) {
            return new ActionResult(ActionResultType.FAIL, (Object)binding);
        }
        if (!SoulShards.CONFIG.getEntityList().isEnabled(binding.getBoundEntity())) {
            return new ActionResult(ActionResultType.FAIL, (Object)binding);
        }
        if (!SoulShards.CONFIG.getBalance().requireRedstoneSignal() ? (Boolean)state.func_177229_b(BlockSoulCage.POWERED) != false && tier.checkRedstone() : (Boolean)state.func_177229_b(BlockSoulCage.POWERED) == false) {
            return new ActionResult(ActionResultType.FAIL, (Object)binding);
        }
        if (tier.checkPlayer() && this.func_145831_w().func_217366_a((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 16.0, false) == null) {
            return new ActionResult(ActionResultType.FAIL, (Object)binding);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)binding);
    }

    private boolean canSpawnInLight(LivingEntity entityLiving, BlockPos pos) {
        return !(entityLiving instanceof IMob) || this.field_145850_b.func_226658_a_(LightType.BLOCK, pos) <= 8;
    }

    private boolean hasReachedSpawnCap(LivingEntity living) {
        AxisAlignedBB box = new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 16), (double)(this.func_174877_v().func_177956_o() - 16), (double)(this.func_174877_v().func_177952_p() - 16), (double)(this.func_174877_v().func_177958_n() + 16), (double)(this.func_174877_v().func_177956_o() + 16), (double)(this.func_174877_v().func_177952_p() + 16));
        int mobCount = this.func_145831_w().func_175647_a(living.getClass(), box, e -> e != null && e.getPersistentData().func_74767_n("cageBorn")).size();
        return mobCount >= SoulShards.CONFIG.getBalance().getSpawnCap();
    }

    public void setState(boolean active) {
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof BlockSoulCage)) {
            return;
        }
        this.func_145831_w().func_175656_a(this.func_174877_v(), (BlockState)state.func_206870_a(BlockSoulCage.ACTIVE, (Comparable)Boolean.valueOf(active)));
        this.active = active;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.activeTime = tag.func_74762_e("activeTime");
        this.active = tag.func_74767_n("active");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        tag.func_74768_a("activeTime", this.activeTime);
        tag.func_74757_a("active", this.active);
        return super.func_189515_b(tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return LazyOptional.empty();
        }
        return LazyOptional.of(() -> this.inventory).cast();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Nullable
    public Binding getBinding() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemSoulShard)) {
            return null;
        }
        return ((ItemSoulShard)stack.func_77973_b()).getBinding(stack);
    }

    public boolean ownerOnline() {
        Binding binding = this.getBinding();
        return binding != null && binding.getOwner() != null && this.field_145850_b.func_73046_m().func_184103_al().func_177451_a(binding.getOwner()) == null;
    }

    public static class SoulCageInventory
    extends ItemStackHandler {
        public SoulCageInventory() {
            super(1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!(stack.func_77973_b() instanceof ItemSoulShard)) {
                return stack;
            }
            Binding binding = ((ItemSoulShard)stack.func_77973_b()).getBinding(stack);
            if (binding == null || binding.getBoundEntity() == null || !SoulShards.CONFIG.getEntityList().isEnabled(binding.getBoundEntity())) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    }
}

