/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.item;

import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.silentchaos512.lib.util.PlayerUtils;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.api.IFluidContainer;
import net.silentchaos512.mechanisms.item.EnergyStoringItem;
import net.silentchaos512.mechanisms.util.EnergyUtils;
import net.silentchaos512.mechanisms.util.InventoryUtils;

public class HandPumpItem
extends EnergyStoringItem {
    private static final int MAX_ENERGY = 100000;
    private static final int MAX_RECEIVE = 100;
    private static final int ENERGY_PER_OPERATION = 500;

    public HandPumpItem() {
        super(new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP).func_200917_a(1), 100000, 100, 500);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Fluid fluid;
        FluidStack fluidStack;
        ItemStack emptyContainer;
        LazyOptional lazyOptional;
        BlockPos pos;
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        IEnergyStorage energy = EnergyUtils.getEnergy((ICapabilityProvider)context.func_195996_i());
        if (energy == null) {
            return ActionResultType.PASS;
        }
        if (energy.getEnergyStored() < 500) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        TileEntity tileEntity = world.func_175625_s(pos = context.func_195995_a());
        if (tileEntity != null && (lazyOptional = tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)).isPresent()) {
            IFluidHandler fluidHandler = (IFluidHandler)lazyOptional.orElseThrow(IllegalStateException::new);
            return HandPumpItem.tryExtractFromTank(player, energy, fluidHandler);
        }
        BlockPos posOpposite = context.func_195995_a().func_177972_a(context.func_196000_l());
        BlockState state = world.func_180495_p(posOpposite);
        if (state.func_177230_c() instanceof IBucketPickupHandler && !(emptyContainer = HandPumpItem.takeFluidContainer(player)).func_190926_b() && !(fluidStack = new FluidStack(fluid = ((IBucketPickupHandler)state.func_177230_c()).func_204508_a((IWorld)world, posOpposite, state), 1000)).isEmpty()) {
            HandPumpItem.giveFilledContainer(player, energy, emptyContainer, fluidStack);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType tryExtractFromTank(PlayerEntity player, IEnergyStorage energy, IFluidHandler fluidHandler) {
        ItemStack emptyContainer = HandPumpItem.takeFluidContainer(player);
        if (!emptyContainer.func_190926_b()) {
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                FluidStack fluidStack;
                FluidStack fluidInTank = fluidHandler.getFluidInTank(i);
                if (fluidInTank.getAmount() <= 999 || fluidHandler.drain(fluidStack = new FluidStack(fluidInTank.getFluid(), 1000), IFluidHandler.FluidAction.SIMULATE).getAmount() != 1000) continue;
                fluidHandler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                HandPumpItem.giveFilledContainer(player, energy, emptyContainer, fluidStack);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private static void giveFilledContainer(PlayerEntity player, IEnergyStorage energy, ItemStack emptyContainer, FluidStack fluidStack) {
        ItemStack filledContainer = IFluidContainer.fillBucketOrFluidContainer(emptyContainer, fluidStack);
        energy.extractEnergy(500, false);
        PlayerUtils.giveItem((PlayerEntity)player, (ItemStack)filledContainer);
    }

    private static ItemStack takeFluidContainer(PlayerEntity player) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!InventoryUtils.isEmptyFluidContainer(stack)) continue;
            ItemStack split = stack.func_77979_a(1);
            if (stack.func_190926_b()) {
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            return split;
        }
        return ItemStack.field_190927_a;
    }
}

