/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.SidedItemStackHandlerWrapper;
import com.blakebr0.cucumber.lib.Localizable;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe;
import com.blakebr0.mysticalagriculture.api.crafting.RecipeTypes;
import com.blakebr0.mysticalagriculture.block.ReprocessorBlock;
import com.blakebr0.mysticalagriculture.container.ReprocessorContainer;
import com.blakebr0.mysticalagriculture.tileentity.ModTileEntities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public abstract class ReprocessorTileEntity
extends BaseInventoryTileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    private final BaseItemStackHandler inventory = new BaseItemStackHandler(3);
    private final LazyOptional<IItemHandlerModifiable>[] handlers = SidedItemStackHandlerWrapper.create((BaseItemStackHandler)this.inventory, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH}, this::canInsertStackSided, null);
    private ISpecialRecipe recipe;
    private int progress;
    private int fuel;
    private int fuelLeft;
    private int fuelItemValue;
    private final IIntArray data = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return ReprocessorTileEntity.this.getProgress();
                }
                case 1: {
                    return ReprocessorTileEntity.this.getFuel();
                }
                case 2: {
                    return ReprocessorTileEntity.this.getFuelLeft();
                }
                case 3: {
                    return ReprocessorTileEntity.this.getFuelItemValue();
                }
                case 4: {
                    return ReprocessorTileEntity.this.getOperationTime();
                }
                case 5: {
                    return ReprocessorTileEntity.this.getFuelCapacity();
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
        }

        public int func_221478_a() {
            return 6;
        }
    };

    public ReprocessorTileEntity(TileEntityType<?> type) {
        super(type);
        this.inventory.setSlotValidator(this::canInsertStack);
        this.inventory.setOutputSlots(new int[]{2});
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        this.progress = tag.func_74762_e("Progress");
        this.fuel = tag.func_74762_e("Fuel");
        this.fuelLeft = tag.func_74762_e("FuelLeft");
        this.fuelItemValue = tag.func_74762_e("FuelItemValue");
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("Progress", this.progress);
        tag.func_74768_a("Fuel", this.fuel);
        tag.func_74768_a("FuelLeft", this.fuelLeft);
        tag.func_74768_a("FuelItemValue", this.fuelItemValue);
        return tag;
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (world == null || world.func_201670_d()) {
            return;
        }
        boolean mark = false;
        int fuelPerTick = Math.min(Math.min(this.fuelLeft, this.getFuelUsage() * 2), this.getFuelCapacity() - this.fuel);
        if (this.fuel < this.getFuelCapacity()) {
            ItemStack fuel = this.inventory.getStackInSlot(1);
            if (this.fuelLeft <= 0 && !fuel.func_190926_b()) {
                this.fuelItemValue = ForgeHooks.getBurnTime((ItemStack)fuel);
                if (this.fuelItemValue > 0) {
                    this.fuelLeft = this.fuelItemValue;
                    this.inventory.extractItemSuper(1, 1, false);
                }
            }
            if (this.fuelLeft > 0) {
                this.fuel += fuelPerTick;
                this.fuelLeft -= fuelPerTick;
                if (this.fuelLeft <= 0) {
                    this.fuelItemValue = 0;
                }
                mark = true;
            }
        }
        if (this.fuel >= this.getFuelUsage()) {
            ItemStack input = this.inventory.getStackInSlot(0);
            ItemStack output = this.inventory.getStackInSlot(2);
            if (!input.func_190926_b()) {
                ItemStack recipeOutput;
                if (this.recipe == null || !this.recipe.matches((IItemHandler)this.inventory)) {
                    IReprocessorRecipe recipe = world.func_199532_z().func_215371_a(RecipeTypes.REPROCESSOR, this.inventory.toIInventory(), world).orElse(null);
                    ISpecialRecipe iSpecialRecipe = this.recipe = recipe instanceof ISpecialRecipe ? (ISpecialRecipe)recipe : null;
                }
                if (this.recipe != null && !(recipeOutput = this.recipe.func_77571_b()).func_190926_b() && (output.func_190926_b() || StackHelper.canCombineStacks((ItemStack)output, (ItemStack)recipeOutput))) {
                    ++this.progress;
                    this.fuel -= this.getFuelUsage();
                    if (this.progress >= this.getOperationTime()) {
                        this.inventory.extractItemSuper(0, 1, false);
                        if (output.func_190926_b()) {
                            this.inventory.setStackInSlot(2, recipeOutput.func_77946_l());
                        } else {
                            output.func_190917_f(recipeOutput.func_190916_E());
                        }
                        this.progress = 0;
                    }
                    mark = true;
                }
            } else if (this.progress > 0) {
                this.progress = 0;
                this.recipe = null;
                mark = true;
            }
        }
        if (mark) {
            this.func_70296_d();
        }
    }

    public ITextComponent func_145748_c_() {
        return Localizable.of((String)"container.mysticalagriculture.reprocessor").build();
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return ReprocessorContainer.create(id, playerInventory, arg_0 -> ((ReprocessorTileEntity)this).isUsableByPlayer(arg_0), this.inventory, this.data);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (side == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(cap, side);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        return this.getTier().getOperationTime();
    }

    public int getFuel() {
        return this.fuel;
    }

    public int getFuelUsage() {
        return this.getTier().getFuelUsage();
    }

    public int getFuelCapacity() {
        return this.getTier().getFuelCapacity();
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public abstract ReprocessorBlock.ReprocessorTier getTier();

    private boolean canInsertStack(int slot, ItemStack stack) {
        return this.canInsertStackSided(slot, stack, null);
    }

    public boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return true;
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceTileEntity.func_213991_b((ItemStack)stack);
        }
        return false;
    }

    public static class Supremium
    extends ReprocessorTileEntity {
        public Supremium() {
            super((TileEntityType)ModTileEntities.SUPREMIUM_REPROCESSOR.get());
        }

        @Override
        public ReprocessorBlock.ReprocessorTier getTier() {
            return ReprocessorBlock.ReprocessorTier.SUPREMIUM;
        }
    }

    public static class Imperium
    extends ReprocessorTileEntity {
        public Imperium() {
            super((TileEntityType)ModTileEntities.IMPERIUM_REPROCESSOR.get());
        }

        @Override
        public ReprocessorBlock.ReprocessorTier getTier() {
            return ReprocessorBlock.ReprocessorTier.IMPERIUM;
        }
    }

    public static class Tertium
    extends ReprocessorTileEntity {
        public Tertium() {
            super((TileEntityType)ModTileEntities.TERTIUM_REPROCESSOR.get());
        }

        @Override
        public ReprocessorBlock.ReprocessorTier getTier() {
            return ReprocessorBlock.ReprocessorTier.TERTIUM;
        }
    }

    public static class Prudentium
    extends ReprocessorTileEntity {
        public Prudentium() {
            super((TileEntityType)ModTileEntities.PRUDENTIUM_REPROCESSOR.get());
        }

        @Override
        public ReprocessorBlock.ReprocessorTier getTier() {
            return ReprocessorBlock.ReprocessorTier.PRUDENTIUM;
        }
    }

    public static class Inferium
    extends ReprocessorTileEntity {
        public Inferium() {
            super((TileEntityType)ModTileEntities.INFERIUM_REPROCESSOR.get());
        }

        @Override
        public ReprocessorBlock.ReprocessorTier getTier() {
            return ReprocessorBlock.ReprocessorTier.INFERIUM;
        }
    }

    public static class Basic
    extends ReprocessorTileEntity {
        public Basic() {
            super((TileEntityType)ModTileEntities.BASIC_REPROCESSOR.get());
        }

        @Override
        public ReprocessorBlock.ReprocessorTier getTier() {
            return ReprocessorBlock.ReprocessorTier.BASIC;
        }
    }
}

