/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.cucumber.helper.NBTHelper;
import com.blakebr0.cucumber.item.BaseItem;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;

public class EssenceWateringCanItem
extends BaseItem {
    private final int range;
    private final double chance;
    private final TextFormatting textColor;

    public EssenceWateringCanItem(int range, double chance, TextFormatting textColor, Function<Item.Properties, Item.Properties> properties) {
        super(properties.compose(p -> p.func_200917_a(1)));
        this.range = range;
        this.chance = chance;
        this.textColor = textColor;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            ItemStack stack = new ItemStack((IItemProvider)this);
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)false);
            NBTHelper.setBoolean((ItemStack)stack, (String)"Active", (boolean)false);
            items.add((Object)stack);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        PlayerEntity player;
        BlockRayTraceResult result;
        if (selected && world.func_82737_E() % 4L == 0L && NBTHelper.getBoolean((ItemStack)stack, (String)"Active") && entity instanceof PlayerEntity && (result = (BlockRayTraceResult)EssenceWateringCanItem.func_219968_a((World)world, (PlayerEntity)(player = (PlayerEntity)entity), (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY)).func_216346_c() != RayTraceResult.Type.MISS) {
            this.doWater(stack, world, player, result.func_216350_a(), result.func_216354_b());
        }
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    public boolean func_77636_d(ItemStack stack) {
        return NBTHelper.getBoolean((ItemStack)stack, (String)"Active");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        BlockState state;
        ItemStack stack = player.func_184586_b(hand);
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        RayTraceResult trace = EssenceWateringCanItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (trace.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
        BlockPos pos = blockTrace.func_216350_a();
        Direction direction = blockTrace.func_216354_b();
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos.func_177972_a(direction), direction, stack) && (state = world.func_180495_p(pos)).func_185904_a() == Material.field_151586_h) {
            NBTHelper.setBoolean((ItemStack)stack, (String)"Water", (boolean)true);
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.FAIL;
        }
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos.func_177972_a(direction), direction, stack)) {
            return ActionResultType.FAIL;
        }
        if (!NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return ActionResultType.PASS;
        }
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Active")) {
            return ActionResultType.FAIL;
        }
        return this.doWater(stack, world, player, pos, direction);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag advanced) {
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            tooltip.add(ModTooltips.FILLED.build());
        } else {
            tooltip.add(ModTooltips.EMPTY.build());
        }
        String rangeString = String.valueOf(this.range);
        ITextComponent rangeNumber = new StringTextComponent(rangeString + "x" + rangeString).func_211708_a(this.textColor);
        tooltip.add(ModTooltips.WATERING_CAN_AREA.args(new Object[]{rangeNumber}).build());
    }

    private ActionResultType doWater(ItemStack stack, World world, PlayerEntity player, BlockPos pos, Direction direction) {
        if (player == null) {
            return ActionResultType.FAIL;
        }
        if (!player.func_175151_a(pos.func_177972_a(direction), direction, stack)) {
            return ActionResultType.FAIL;
        }
        if (!NBTHelper.getBoolean((ItemStack)stack, (String)"Water")) {
            return ActionResultType.FAIL;
        }
        int range = (this.range - 1) / 2;
        Stream blocks = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range));
        blocks.forEach(aoePos -> {
            int moisture;
            BlockState aoeState = world.func_180495_p(aoePos);
            if (aoeState.func_177230_c() instanceof FarmlandBlock && (moisture = ((Integer)aoeState.func_177229_b((IProperty)FarmlandBlock.field_176531_a)).intValue()) < 7) {
                world.func_180501_a(aoePos, (BlockState)aoeState.func_206870_a((IProperty)FarmlandBlock.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
            }
        });
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                double d0 = (float)pos.func_177982_a(x, 0, z).func_177958_n() + world.func_201674_k().nextFloat();
                double d1 = (double)pos.func_177982_a(x, 0, z).func_177956_o() + 1.0;
                double d2 = (float)pos.func_177982_a(x, 0, z).func_177952_p() + world.func_201674_k().nextFloat();
                BlockState state = world.func_180495_p(pos);
                if (state.func_200132_m() || state.func_177230_c() instanceof FarmlandBlock) {
                    d1 += 0.3;
                }
                world.func_195594_a((IParticleData)ParticleTypes.field_197600_K, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
        if (!world.func_201670_d() && Math.random() <= this.chance) {
            blocks = BlockPos.func_218281_b((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range));
            blocks.forEach(aoePos -> {
                Block plantBlock = world.func_180495_p(aoePos).func_177230_c();
                if (plantBlock instanceof IGrowable || plantBlock instanceof IPlantable || plantBlock == Blocks.field_150391_bh || plantBlock == Blocks.field_185766_cS) {
                    world.func_205220_G_().func_205360_a(aoePos, (Object)plantBlock, 4);
                }
            });
            return ActionResultType.FAIL;
        }
        return ActionResultType.FAIL;
    }
}

