/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client;

import com.blakebr0.cucumber.model.RetextureableBlockModelWrapper;
import com.blakebr0.cucumber.model.RetextureableItemModelWrapper;
import com.blakebr0.mysticalagriculture.api.MysticalAgricultureAPI;
import com.blakebr0.mysticalagriculture.api.crop.CropTextures;
import com.blakebr0.mysticalagriculture.api.crop.CropType;
import com.blakebr0.mysticalagriculture.api.crop.ICrop;
import com.blakebr0.mysticalagriculture.block.ModBlocks;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.SpriteMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"Mystical Agriculture");
    private static final ResourceLocation MISSING_NO = new ResourceLocation("minecraft", "missingno");
    private static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("minecraft", "textures/atlas/blocks.png");

    @SubscribeEvent
    public void onRegisterModels(ModelRegistryEvent event) {
        for (int i = 0; i < 8; ++i) {
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "block/mystical_resource_crop_" + i));
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "block/mystical_mob_crop_" + i));
        }
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "item/mystical_essence"));
        ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation("mysticalagriculture", "item/mystical_seeds"));
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent event) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map registry = event.getModelRegistry();
        ModelLoader bakery = event.getModelLoader();
        HashMap cropModels = new HashMap();
        HashMap cropModelsGrown = new HashMap();
        MysticalAgricultureAPI.CROP_TYPES.forEach(arg_0 -> ModelHandler.lambda$onModelBake$2(cropModels, registry, (ModelBakery)bakery, cropModelsGrown, arg_0));
        Function<Material, TextureAtlasSprite> getSprite = arg_0 -> ((SpriteMap)bakery.getSpriteMap()).func_229151_a_(arg_0);
        ItemModelGenerator generator = new ItemModelGenerator();
        IUnbakedModel essenceModel = bakery.func_209597_a(new ResourceLocation("mysticalagriculture", "item/mystical_essence"));
        RetextureableItemModelWrapper essenceModelWrapper = new RetextureableItemModelWrapper((BlockModel)essenceModel);
        IUnbakedModel seedsModel = bakery.func_209597_a(new ResourceLocation("mysticalagriculture", "item/mystical_seeds"));
        RetextureableItemModelWrapper seedsModelWrapper = new RetextureableItemModelWrapper((BlockModel)seedsModel);
        CropRegistry.getInstance().getCrops().forEach(arg_0 -> ModelHandler.lambda$onModelBake$3(registry, cropModels, cropModelsGrown, (ModelBakery)bakery, getSprite, essenceModelWrapper, generator, seedsModelWrapper, arg_0));
        stopwatch.stop();
        LOGGER.info("Model replacement took {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)BLOCK_ATLAS)) {
            CropRegistry.getInstance().getCrops().forEach(crop -> {
                CropTextures textures = crop.getTextures();
                event.addSprite(textures.getFlowerTexture());
                event.addSprite(textures.getEssenceTexture());
                event.addSprite(textures.getSeedTexture());
            });
        }
    }

    public static void onClientSetup() {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.PROSPERITY_ORE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.INFERIUM_ORE.get()), (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.SOULIUM_ORE.get()), (RenderType)RenderType.func_228641_d_());
        CropRegistry.getInstance().getCrops().forEach(crop -> RenderTypeLookup.setRenderLayer((Block)crop.getCrop(), (RenderType)RenderType.func_228641_d_()));
    }

    private static /* synthetic */ void lambda$onModelBake$3(Map registry, Map cropModels, Map cropModelsGrown, ModelBakery bakery, Function getSprite, RetextureableItemModelWrapper essenceModelWrapper, ItemModelGenerator generator, RetextureableItemModelWrapper seedsModelWrapper, ICrop crop) {
        ModelResourceLocation location;
        IBakedModel bakedModel;
        BlockNamedItem seeds;
        Item essence;
        IBakedModel bakedModel2;
        ModelResourceLocation location2;
        CropTextures textures = crop.getTextures();
        CropsBlock crops = crop.getCrop();
        if (crops.getRegistryName() != null) {
            for (int i = 0; i < 7; ++i) {
                location2 = new ModelResourceLocation(crops.getRegistryName(), "age=" + i);
                bakedModel2 = (IBakedModel)registry.get(location2);
                if (bakedModel2 != null && !bakedModel2.getParticleTexture((IModelData)EmptyModelData.INSTANCE).func_195668_m().equals((Object)MISSING_NO)) continue;
                String type = crop.getType().getName();
                registry.replace(location2, ((IBakedModel[])cropModels.get(type))[i]);
            }
            ModelResourceLocation location3 = new ModelResourceLocation(crops.getRegistryName(), "age=7");
            IBakedModel bakedModel3 = (IBakedModel)registry.get(location3);
            if (bakedModel3 == null || bakedModel3.getParticleTexture((IModelData)EmptyModelData.INSTANCE).func_195668_m().equals((Object)MISSING_NO)) {
                ResourceLocation texture = crop.getTextures().getFlowerTexture();
                RetextureableBlockModelWrapper cropRetexturedModel = ((RetextureableBlockModelWrapper)cropModelsGrown.get(crop.getType().getName())).retexture(ImmutableMap.of((Object)"flower", (Object)texture.toString()));
                IBakedModel cropBakedModel = cropRetexturedModel.func_225613_a_(bakery, getSprite, (IModelTransform)ModelRotation.X0_Y0, (ResourceLocation)location3);
                registry.replace(location3, cropBakedModel);
            }
        }
        if ((essence = crop.getEssence()).getRegistryName() != null && ((bakedModel2 = (IBakedModel)registry.get(location2 = new ModelResourceLocation(essence.getRegistryName(), "inventory"))) == null || bakedModel2.getParticleTexture((IModelData)EmptyModelData.INSTANCE).func_195668_m().equals((Object)MISSING_NO))) {
            ResourceLocation texture = textures.getEssenceTexture();
            RetextureableBlockModelWrapper retexture = essenceModelWrapper.retexture(ImmutableMap.of((Object)"layer0", (Object)texture.toString()));
            BlockModel generated = generator.func_209579_a(getSprite, (BlockModel)retexture);
            IBakedModel model = generated.func_225613_a_(bakery, getSprite, (IModelTransform)ModelRotation.X0_Y0, (ResourceLocation)location2);
            registry.replace(location2, model);
        }
        if ((seeds = crop.getSeeds()).getRegistryName() != null && ((bakedModel = (IBakedModel)registry.get(location = new ModelResourceLocation(seeds.getRegistryName(), "inventory"))) == null || bakedModel.getParticleTexture((IModelData)EmptyModelData.INSTANCE).func_195668_m().equals((Object)MISSING_NO))) {
            ResourceLocation texture = textures.getSeedTexture();
            RetextureableBlockModelWrapper retexture = seedsModelWrapper.retexture(ImmutableMap.of((Object)"layer0", (Object)texture.toString()));
            BlockModel generated = generator.func_209579_a(getSprite, (BlockModel)retexture);
            IBakedModel model = generated.func_225613_a_(bakery, getSprite, (IModelTransform)ModelRotation.X0_Y0, (ResourceLocation)location);
            registry.replace(location, model);
        }
    }

    private static /* synthetic */ void lambda$onModelBake$2(Map cropModels, Map registry, ModelBakery bakery, Map cropModelsGrown, CropType type) {
        cropModels.put(type.getName(), IntStream.range(0, 7).mapToObj(i -> (IBakedModel)registry.get(new ResourceLocation(type.getStemModel() + "_" + i))).toArray(IBakedModel[]::new));
        IUnbakedModel model = bakery.func_209597_a(new ResourceLocation(type.getStemModel() + "_7"));
        RetextureableBlockModelWrapper modelWrapper = new RetextureableBlockModelWrapper((BlockModel)model);
        cropModelsGrown.put(type.getName(), modelWrapper);
    }
}

