/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import ovh.corail.tombstone.helper.Location;

public class NBTStackHelper {
    public static ItemStack setString(ItemStack stack, String keyName, String keyValue) {
        stack.func_196082_o().func_74778_a(keyName, keyValue);
        return stack;
    }

    public static String getString(ItemStack stack, String keyName) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(keyName, 8)) {
            return tag.func_74779_i(keyName);
        }
        return "";
    }

    public static ItemStack setBoolean(ItemStack stack, String keyName, boolean keyValue) {
        stack.func_196082_o().func_74757_a(keyName, keyValue);
        return stack;
    }

    public static boolean getBoolean(ItemStack stack, String keyName) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(keyName, 1)) {
            return tag.func_74767_n(keyName);
        }
        return false;
    }

    public static ItemStack setInteger(ItemStack stack, String keyName, int keyValue) {
        stack.func_196082_o().func_74768_a(keyName, keyValue);
        return stack;
    }

    public static int getInteger(ItemStack stack, String keyName) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(keyName, 3)) {
            return tag.func_74762_e(keyName);
        }
        return Integer.MIN_VALUE;
    }

    public static ItemStack setLong(ItemStack stack, String keyName, long keyValue) {
        stack.func_196082_o().func_74772_a(keyName, keyValue);
        return stack;
    }

    @Deprecated
    public static long getLong(ItemStack stack, String keyName) {
        return NBTStackHelper.getLong(stack, keyName, Long.MIN_VALUE);
    }

    public static long getLong(ItemStack stack, String keyName, long fallback) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b(keyName, 4)) {
            return tag.func_74763_f(keyName);
        }
        return fallback;
    }

    public static ItemStack setBlockPos(ItemStack stack, String keyName, BlockPos keyValue) {
        NBTStackHelper.setBlockPos(stack.func_196082_o(), keyName, keyValue);
        return stack;
    }

    public static void setBlockPos(CompoundNBT tag, String keyName, BlockPos keyValue) {
        tag.func_74768_a(keyName + "X", keyValue.func_177958_n());
        tag.func_74768_a(keyName + "Y", keyValue.func_177956_o());
        tag.func_74768_a(keyName + "Z", keyValue.func_177952_p());
    }

    public static BlockPos getBlockPos(ItemStack stack, String keyName) {
        return NBTStackHelper.getBlockPos(stack.func_77978_p(), keyName);
    }

    public static BlockPos getBlockPos(@Nullable CompoundNBT tag, String keyName) {
        if (tag != null && tag.func_150297_b(keyName + "X", 3) && tag.func_150297_b(keyName + "Y", 3) && tag.func_150297_b(keyName + "Z", 3)) {
            return new BlockPos(tag.func_74762_e(keyName + "X"), tag.func_74762_e(keyName + "Y"), tag.func_74762_e(keyName + "Z"));
        }
        return Location.ORIGIN_POS;
    }

    public static ItemStack setLocation(ItemStack stack, String keyName, Location location) {
        NBTStackHelper.setLocation(stack.func_196082_o(), keyName, location);
        return stack;
    }

    public static CompoundNBT setLocation(CompoundNBT tag, String keyName, Location location) {
        NBTStackHelper.setBlockPos(tag, keyName, location.getPos());
        tag.func_74768_a(keyName + "D", location.dim);
        return tag;
    }

    public static Location getLocation(ItemStack stack, String keyName) {
        return NBTStackHelper.getLocation(stack.func_77978_p(), keyName);
    }

    public static Location getLocation(@Nullable CompoundNBT tag, String keyName) {
        BlockPos pos;
        if (tag != null && tag.func_74764_b(keyName + "D") && !(pos = NBTStackHelper.getBlockPos(tag, keyName)).equals((Object)Location.ORIGIN_POS)) {
            return new Location(pos, tag.func_74762_e(keyName + "D"));
        }
        return Location.ORIGIN;
    }

    public static boolean removeLocation(ItemStack stack, String keyName) {
        boolean removed = NBTStackHelper.removeKeyName(stack, keyName + "X");
        removed = NBTStackHelper.removeKeyName(stack, keyName + "Y") || removed;
        removed = NBTStackHelper.removeKeyName(stack, keyName + "Z") || removed;
        return NBTStackHelper.removeKeyName(stack, keyName + "D") || removed;
    }

    public static boolean removeKeyName(ItemStack stack, String keyName) {
        CompoundNBT tag = stack.func_77978_p();
        boolean removed = false;
        if (tag != null && tag.func_74764_b(keyName)) {
            removed = true;
            tag.func_82580_o(keyName);
            if (tag.isEmpty()) {
                stack.func_77982_d(null);
            }
        }
        return removed;
    }

    public static List<EffectInstance> getEffectList(CompoundNBT tag, String keyName, Predicate<Effect> predic) {
        ArrayList<EffectInstance> effectInstances = new ArrayList<EffectInstance>();
        if (tag.func_150297_b(keyName, 9)) {
            ListNBT effectList = tag.func_150295_c(keyName, 10);
            for (int i = 0; i < effectList.size(); ++i) {
                EffectInstance effectInstance = NBTStackHelper.getEffect(effectList.func_150305_b(i), predic);
                if (effectInstance == null) continue;
                effectInstances.add(effectInstance);
            }
        }
        return effectInstances;
    }

    public static void setEffectlist(CompoundNBT tag, String keyName, Stream<EffectInstance> effectInstances) {
        ListNBT effectList = new ListNBT();
        effectInstances.forEach(effectInstance -> effectList.add((Object)NBTStackHelper.setEffect(new CompoundNBT(), effectInstance)));
        tag.func_218657_a(keyName, (INBT)effectList);
    }

    public static CompoundNBT setEffect(CompoundNBT tag, EffectInstance effectInstance) {
        effectInstance.func_82719_a(tag);
        return tag;
    }

    @Nullable
    public static EffectInstance getEffect(CompoundNBT tag, Predicate<Effect> predic) {
        EffectInstance effectInstance = null;
        if (tag.func_150297_b("ShowIcon", 1) && predic.test((effectInstance = EffectInstance.func_82722_b((CompoundNBT)tag)).func_188419_a())) {
            return effectInstance;
        }
        return null;
    }
}

