/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.api.capability;

import com.google.common.annotations.Beta;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;
import ovh.corail.tombstone.api.TombstoneAPIProps;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.cooldown.CooldownType;

public interface ITBCapability
extends INBTSerializable<CompoundNBT> {
    public long getKnowledge();

    public ITBCapability setKnowledge(long var1);

    public ITBCapability addKnowledgeAndSync(ServerPlayerEntity var1, long var2);

    public ITBCapability removeKnowledgeAndSync(ServerPlayerEntity var1, long var2);

    public long getKnowledgeForLevel(int var1);

    public long getKnowledgeToReachNextLevel(int var1);

    public int getUsedPerkPoints(PlayerEntity var1);

    public int getTotalPerkPoints();

    public Map<Perk, Integer> getPerks();

    public ITBCapability setPerks(Map<Perk, Integer> var1);

    public ITBCapability setPerk(Perk var1, int var2);

    public boolean removePerk(Perk var1);

    public int getPerkLevel(PlayerEntity var1, Perk var2);

    public int getPerkLevelWithBonus(PlayerEntity var1, @Nullable Perk var2);

    public boolean canResetPerks(PlayerEntity var1);

    public boolean resetPerks(ServerPlayerEntity var1);

    public ITBCapability copyCapability(ITBCapability var1);

    public ITBCapability syncAll(ServerPlayerEntity var1);

    @Beta
    public ITBCapability increaseAlignment(int var1);

    @Beta
    public ITBCapability decreaseAlignment(int var1);

    @Beta
    public int getAlignmentValue();

    @Beta
    public int getAlignmentMinValue();

    @Beta
    public int getAlignmentMaxValue();

    @Beta
    public int getAlignmentLevel();

    @Beta
    public ITBCapability setAlignment(int var1);

    @Beta
    public ITBCapability addAlignmentAndSync(ServerPlayerEntity var1, int var2);

    @Beta
    public ITBCapability onAlignmentLevelChange(int var1, int var2);

    @Deprecated
    default public boolean canPray(PlayerEntity player) {
        return !TombstoneAPIProps.COOLDOWN_HANDLER.hasCooldown(player, CooldownType.NEXT_PRAY);
    }

    @Deprecated
    default public int getCooldownToPray(PlayerEntity player) {
        return TombstoneAPIProps.COOLDOWN_HANDLER.getCooldown(player, CooldownType.NEXT_PRAY);
    }

    @Deprecated
    default public int getMaxPrayTime(PlayerEntity player) {
        return CooldownType.NEXT_PRAY.getMaxCooldown(player);
    }

    @Deprecated
    default public ITBCapability resetNextPray(PlayerEntity player) {
        if (!player.field_70170_p.field_72995_K) {
            TombstoneAPIProps.COOLDOWN_HANDLER.resetCooldown((ServerPlayerEntity)player, CooldownType.NEXT_PRAY);
        }
        return this;
    }

    @Deprecated
    default public long getCooldownToResetPerks(PlayerEntity player) {
        return TombstoneAPIProps.COOLDOWN_HANDLER.getCooldown(player, CooldownType.RESET_PERKS);
    }

    @Deprecated
    default public boolean resetPerksAndSync(ServerPlayerEntity player) {
        return this.resetPerks(player);
    }
}

