/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.lexer;

import java.util.HashMap;
import java.util.Map;
import org.openzen.zenscript.lexer.TokenFactory;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenType;

public class ZSTokenFactory
implements TokenFactory<ZSToken, ZSTokenType> {
    private static final Map<String, ZSToken> KEYWORDS = new HashMap<String, ZSToken>();
    private final int spacesPerTab;

    public ZSTokenFactory(int spacesPerTab) {
        this.spacesPerTab = spacesPerTab;
    }

    @Override
    public ZSToken create(ZSTokenType type, String content) {
        if (type == ZSTokenType.T_IDENTIFIER && KEYWORDS.containsKey(content)) {
            return KEYWORDS.get(content);
        }
        if (type.flyweight != null) {
            return type.flyweight;
        }
        return new ZSToken(type, content);
    }

    static {
        for (ZSTokenType type : ZSTokenType.values()) {
            if (!type.isKeyword) continue;
            KEYWORDS.put(type.flyweight.content, type.flyweight);
        }
    }
}

