/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.scope;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.GenericMapper;
import org.openzen.zenscript.codemodel.GenericName;
import org.openzen.zenscript.codemodel.annotations.AnnotationDefinition;
import org.openzen.zenscript.codemodel.definition.ZSPackage;
import org.openzen.zenscript.codemodel.generic.TypeParameter;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.partial.PartialTypeExpression;
import org.openzen.zenscript.codemodel.scope.BaseScope;
import org.openzen.zenscript.codemodel.statement.LoopStatement;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.codemodel.type.TypeID;
import org.openzen.zenscript.codemodel.type.member.LocalMemberCache;
import org.openzen.zenscript.codemodel.type.member.TypeMemberPreparer;
import org.openzen.zenscript.codemodel.type.storage.StorageTag;

public class GenericFunctionScope
extends BaseScope {
    private final BaseScope outer;
    private final Map<String, TypeParameter> parameters = new HashMap<String, TypeParameter>();

    public GenericFunctionScope(BaseScope outer, TypeParameter[] parameters) {
        this.outer = outer;
        if (parameters != null) {
            for (TypeParameter parameter : parameters) {
                this.parameters.put(parameter.name, parameter);
            }
        }
    }

    @Override
    public ZSPackage getRootPackage() {
        return this.outer.getRootPackage();
    }

    @Override
    public LocalMemberCache getMemberCache() {
        return this.outer.getMemberCache();
    }

    @Override
    public IPartialExpression get(CodePosition position, GenericName name) throws CompileException {
        if (this.parameters.containsKey(name.name) && name.hasNoArguments()) {
            return new PartialTypeExpression(position, this.getTypeRegistry().getGeneric(this.parameters.get(name.name)), name.arguments);
        }
        return this.outer.get(position, name);
    }

    @Override
    public TypeID getType(CodePosition position, List<GenericName> name) {
        if (name.size() == 1 && this.parameters.containsKey(name.get((int)0).name) && name.get(0).hasNoArguments()) {
            return this.getTypeRegistry().getGeneric(this.parameters.get(name.get((int)0).name));
        }
        return this.outer.getType(position, name);
    }

    @Override
    public StorageTag getStorageTag(CodePosition position, String name, String[] parameters) {
        return this.outer.getStorageTag(position, name, parameters);
    }

    @Override
    public LoopStatement getLoop(String name) {
        return this.outer.getLoop(name);
    }

    @Override
    public FunctionHeader getFunctionHeader() {
        return this.outer.getFunctionHeader();
    }

    @Override
    public StoredType getThisType() {
        return this.outer.getThisType();
    }

    @Override
    public BaseScope.DollarEvaluator getDollar() {
        return this.outer.getDollar();
    }

    @Override
    public IPartialExpression getOuterInstance(CodePosition position) throws CompileException {
        return this.outer.getOuterInstance(position);
    }

    @Override
    public AnnotationDefinition getAnnotation(String name) {
        return this.outer.getAnnotation(name);
    }

    @Override
    public TypeMemberPreparer getPreparer() {
        return this.outer.getPreparer();
    }

    @Override
    public GenericMapper getLocalTypeParameters() {
        return this.outer.getLocalTypeParameters();
    }
}

