/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.StoredType;

public class StorageCastExpression
extends Expression {
    public final Expression value;

    public StorageCastExpression(CodePosition position, Expression value, StoredType toType) {
        super(position, toType, value.thrownType);
        this.value = value;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitStorageCast(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitStorageCast(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        Expression transformed = transformer.transform(this.value);
        return transformed == this ? this : new StorageCastExpression(this.position, transformed, this.type);
    }

    @Override
    public Expression normalize(TypeScope scope) {
        Expression normalized = this.value.normalize(scope);
        return normalized == this.value ? this : new StorageCastExpression(this.position, normalized, this.type);
    }
}

