/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.ingredients.transform;

import com.blamejared.crafttweaker.CraftTweakerRegistries;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformer;
import com.blamejared.crafttweaker.api.item.transformed.IIngredientTransformerSerializer;
import com.blamejared.crafttweaker.impl.item.MCItemStack;
import com.google.gson.JsonObject;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class TransformDamage<T extends IIngredient>
implements IIngredientTransformer<T> {
    private final int amount;

    public TransformDamage(int amount) {
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    @Override
    public IItemStack transform(IItemStack stack) {
        ItemStack internal = stack.getInternal().func_77946_l();
        int newDamage = internal.func_77952_i() + this.amount;
        if (internal.func_77958_k() < newDamage) {
            return MCItemStack.EMPTY.get();
        }
        internal.func_196085_b(newDamage);
        return new MCItemStack(internal);
    }

    @Override
    public String getCommandString(T transformedIngredient) {
        if (this.amount == 1) {
            return transformedIngredient.getCommandString() + ".transformDamage()";
        }
        return String.format("%s.transformDamage(%s)", transformedIngredient.getCommandString(), this.amount);
    }

    @Override
    public IIngredientTransformerSerializer getSerializer() {
        return CraftTweakerRegistries.TRANSFORM_DAMAGE_SERIALIZER;
    }

    public static final class TransformDamageSerializer
    implements IIngredientTransformerSerializer<TransformDamage<?>> {
        @Override
        public TransformDamage<?> parse(PacketBuffer buffer) {
            return new TransformDamage(buffer.func_150792_a());
        }

        @Override
        public TransformDamage<?> parse(JsonObject json) {
            return new TransformDamage(json.getAsJsonPrimitive("amount").getAsInt());
        }

        @Override
        public void write(PacketBuffer buffer, TransformDamage<?> ingredient) {
            buffer.func_150787_b(((TransformDamage)ingredient).amount);
        }

        @Override
        public JsonObject toJson(TransformDamage<?> transformer) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("amount", (Number)((TransformDamage)transformer).amount);
            return jsonObject;
        }

        @Override
        public ResourceLocation getType() {
            return new ResourceLocation("crafttweaker", "transform_damage");
        }
    }
}

