/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile;

import com.bluepowermod.api.multipart.IBPPartBlock;
import com.bluepowermod.tile.BPTileEntityType;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.extensions.IForgeBlockState;
import net.minecraftforge.common.util.LazyOptional;

public class TileBPMultipart
extends TileEntity
implements ITickableTileEntity {
    public static final ModelProperty<Map<BlockState, IModelData>> PROPERTY_INFO = new ModelProperty();
    private Map<BlockState, TileEntity> stateMap = new HashMap<BlockState, TileEntity>();

    public TileBPMultipart() {
        super(BPTileEntityType.MULTIPART);
    }

    @Nonnull
    public IModelData getModelData() {
        Map<BlockState, IModelData> modelDataMap = this.stateMap.keySet().stream().filter(IForgeBlockState::hasTileEntity).collect(Collectors.toMap(s -> s, this::getModelData));
        this.stateMap.keySet().stream().filter(s -> !s.hasTileEntity()).forEach(s -> {
            IModelData cfr_ignored_0 = modelDataMap.put((BlockState)s, (IModelData)null);
        });
        return new ModelDataMap.Builder().withInitial(PROPERTY_INFO, modelDataMap).build();
    }

    private IModelData getModelData(BlockState state) {
        if (this.stateMap.get(state) != null) {
            return this.stateMap.get(state).getModelData();
        }
        return EmptyModelData.INSTANCE;
    }

    public void addState(BlockState state) {
        TileEntity tile = state.func_177230_c().createTileEntity(state, (IBlockReader)this.field_145850_b);
        if (tile != null) {
            tile.func_174878_a(this.field_174879_c);
        }
        this.stateMap.put(state, tile);
        state.func_177230_c().func_180633_a(this.field_145850_b, this.field_174879_c, state, null, new ItemStack((IItemProvider)state.func_177230_c()));
        this.markDirtyClient();
    }

    public void removeState(BlockState state) {
        if (this.stateMap.get(state) != null) {
            this.stateMap.get(state).func_145843_s();
        }
        this.stateMap.remove(state);
        this.markDirtyClient();
        if (this.stateMap.size() == 1) {
            TileEntity te = (TileEntity)this.stateMap.values().toArray()[0];
            if (this.field_145850_b != null) {
                CompoundNBT nbt = te != null ? te.func_189515_b(new CompoundNBT()) : null;
                this.field_145850_b.func_175656_a(this.field_174879_c, this.stateMap.keySet().iterator().next());
                TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c);
                if (tile != null && nbt != null) {
                    tile.func_145839_a(nbt);
                }
            }
        } else if (this.stateMap.size() == 0 && this.field_145850_b != null) {
            this.field_145850_b.func_217377_a(this.field_174879_c, false);
        }
        if (this.field_145850_b != null) {
            this.field_145850_b.func_180495_p(this.field_174879_c).func_215697_a(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), this.field_174879_c, false);
        }
    }

    public TileEntity getTileForState(BlockState state) {
        return this.stateMap.get(state);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.isSideBlocked(cap, side).booleanValue()) {
            return LazyOptional.empty();
        }
        List capability = this.stateMap.values().stream().filter(Objects::nonNull).map(t -> t.getCapability(cap, side)).filter(LazyOptional::isPresent).collect(Collectors.toList());
        return capability.size() > 0 ? (LazyOptional)capability.get(0) : LazyOptional.empty();
    }

    public Boolean isSideBlocked(@Nonnull Capability cap, @Nullable Direction side) {
        return this.stateMap.keySet().stream().filter(s -> s.func_177230_c() instanceof IBPPartBlock).anyMatch(s -> ((IBPPartBlock)s.func_177230_c()).blockCapability((BlockState)s, cap, side));
    }

    public List<BlockState> getStates() {
        return new ArrayList<BlockState>(this.stateMap.keySet());
    }

    private void markDirtyClient() {
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            BlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
        this.requestModelDataUpdate();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("size", this.getStates().size());
        for (int i = 0; i < this.getStates().size(); ++i) {
            compound.func_218657_a("state" + i, (INBT)BlockState.func_215689_a((DynamicOps)NBTDynamicOps.field_210820_a, (BlockState)this.getStates().get(i)).getValue());
            if (this.stateMap.get(this.getStates().get(i)) == null) continue;
            compound.func_218657_a("tile" + i, (INBT)this.stateMap.get(this.getStates().get(i)).func_189515_b(new CompoundNBT()));
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        HashMap<BlockState, TileEntity> states = new HashMap<BlockState, TileEntity>();
        int size = compound.func_74762_e("size");
        for (int i = 0; i < size; ++i) {
            BlockState state = BlockState.func_215698_a((Dynamic)new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)compound.func_74781_a("state" + i)));
            TileEntity tile = state.func_177230_c().createTileEntity(state, (IBlockReader)this.func_145831_w());
            if (tile != null) {
                tile.func_145839_a(compound.func_74775_l("tile" + i));
                tile.func_174878_a(this.field_174879_c);
            }
            states.put(state, tile);
        }
        this.stateMap = states;
        this.markDirtyClient();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT updateTag = super.func_189517_E_();
        this.func_189515_b(updateTag);
        return updateTag;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbtTag = new CompoundNBT();
        this.func_189515_b(nbtTag);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbtTag);
    }

    public void onDataPacket(NetworkManager networkManager, SUpdateTileEntityPacket packet) {
        List<BlockState> states = this.getStates();
        CompoundNBT tagCompound = packet.func_148857_g();
        super.onDataPacket(networkManager, packet);
        this.func_145839_a(tagCompound);
        if (this.field_145850_b.field_72995_K && !this.getStates().equals(states)) {
            this.field_145850_b.func_175646_b(this.func_174877_v(), this.getTileEntity());
        }
    }

    public void changeState(BlockState state, BlockState newState) {
        TileEntity te = this.stateMap.get(state);
        this.stateMap.remove(state);
        this.stateMap.put(newState, te);
        this.markDirtyClient();
    }

    public void func_73660_a() {
        this.stateMap.values().stream().filter(t -> t instanceof ITickableTileEntity).forEach(t -> ((ITickableTileEntity)t).func_73660_a());
    }
}

