/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.client.gui.IGuiButtonSensitive;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageGuiUpdate {
    private int messageId;
    private int value;

    public MessageGuiUpdate(int messageId, int value) {
        this.messageId = messageId;
        this.value = value;
    }

    public static MessageGuiUpdate decode(PacketBuffer buffer) {
        byte id = buffer.readByte();
        byte value = buffer.readByte();
        return new MessageGuiUpdate(id, value);
    }

    public static void encode(MessageGuiUpdate message, PacketBuffer buffer) {
        buffer.writeByte(message.messageId);
        buffer.writeByte(message.value);
    }

    public static void handle(MessageGuiUpdate msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            Container container = player.field_71070_bA;
            if (container instanceof IGuiButtonSensitive) {
                ((IGuiButtonSensitive)container).onButtonPress((PlayerEntity)player, msg.messageId, msg.value);
            }
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

