/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.client.gui;

import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class GuiScreenBase
extends Screen {
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;

    public GuiScreenBase(int xSize, int ySize, ITextComponent name) {
        super(name);
        this.xSize = xSize;
        this.ySize = ySize;
    }

    public void init() {
        super.init();
        this.guiLeft = this.width / 2 - this.xSize / 2;
        this.guiTop = this.height / 2 - this.ySize / 2;
    }

    protected abstract ResourceLocation getTexture();

    public void render(int x, int y, float partialTicks) {
        if (this.getTexture() != null) {
            this.renderBackground();
            this.minecraft.func_110434_K().func_110577_a(this.getTexture());
            this.blit(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        }
        super.render(x, y, partialTicks);
    }
}

