/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.client.IDrawable;
import net.blay09.mods.refinedrelocation.api.filter.IChecklistFilter;
import net.blay09.mods.refinedrelocation.client.gui.GuiTextures;
import net.blay09.mods.refinedrelocation.container.ChecklistFilterContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class PresetFilter
implements IChecklistFilter {
    public static final String ID = "refinedrelocation:preset_filter";
    private static final Map<String, Preset> presetMap = Maps.newHashMap();
    private static final List<Preset> presetList = Lists.newArrayList();
    public static final Preset ORES = new Preset("ores"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            for (ResourceLocation tag : tags) {
                if (!tag.func_110623_a().equals("ores")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset INGOTS = new Preset("ingots"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            for (ResourceLocation tag : tags) {
                if (!tag.func_110623_a().equals("ingots")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset NUGGETS = new Preset("nuggets"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            for (ResourceLocation tag : tags) {
                if (!tag.func_110623_a().equals("nuggets")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset GEMS = new Preset("gems"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            for (ResourceLocation tag : tags) {
                if (!tag.func_110623_a().equals("gems")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset DYES = new Preset("dyes"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            for (ResourceLocation tag : tags) {
                if (!tag.func_110623_a().equals("dyes")) continue;
                return true;
            }
            return false;
        }
    };
    public static final Preset FOOD = new Preset("food"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            return itemStack.func_77973_b().func_219971_r();
        }
    };
    public static final Preset FUEL_ITEMS = new Preset("fuel"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            int burnTime = itemStack.getBurnTime();
            burnTime = burnTime == -1 ? ForgeHooks.getBurnTime((ItemStack)itemStack) : burnTime;
            return ForgeEventFactory.getItemBurnTime((ItemStack)itemStack, (int)burnTime) > 0;
        }
    };
    public static final Preset BLOCKS = new Preset("blocks"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            return itemStack.func_77973_b() instanceof BlockItem;
        }
    };
    public static final Preset UNSTACKABLE = new Preset("unstackable"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            return itemStack.func_77976_d() <= 1;
        }
    };
    public static final Preset REPAIRABLE = new Preset("repairable"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            return itemStack.func_77973_b().isRepairable(itemStack);
        }
    };
    public static final Preset WEAPONS = new Preset("weapons"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            return itemStack.func_77973_b() instanceof SwordItem || itemStack.func_77973_b() instanceof BowItem;
        }
    };
    public static final Preset ARMORS = new Preset("armors"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            return itemStack.func_77973_b() instanceof ArmorItem;
        }
    };
    public static final Preset TOOLS = new Preset("tools"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            return itemStack.func_77973_b() == Items.field_151146_bM || itemStack.func_77973_b() == Items.field_151033_d || itemStack.func_77973_b() instanceof ToolItem || itemStack.func_77973_b() instanceof FishingRodItem || itemStack.func_77973_b() instanceof ShearsItem;
        }
    };
    public static final Preset ENCHANTED = new Preset("enchanted"){

        @Override
        public boolean passes(ItemStack itemStack, Collection<ResourceLocation> tags) {
            return itemStack.func_77948_v();
        }
    };
    private final boolean[] presetStates = new boolean[presetList.size()];

    private static void registerPreset(Preset preset) {
        presetMap.put(preset.getId(), preset);
        presetList.add(preset);
    }

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileEntity tileEntity) {
        return true;
    }

    @Override
    public boolean passes(TileEntity tileEntity, ItemStack itemStack) {
        Collection tags = ItemTags.func_199903_a().func_199913_a((Object)itemStack.func_77973_b());
        for (int i = 0; i < presetList.size(); ++i) {
            if (!this.presetStates[i] || !presetList.get(i).passes(itemStack, tags)) continue;
            return true;
        }
        return false;
    }

    public INBT serializeNBT() {
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.presetStates.length; ++i) {
            if (!this.presetStates[i]) continue;
            list.add((Object)StringNBT.func_229705_a_((String)presetList.get(i).getId()));
        }
        return list;
    }

    public void deserializeNBT(INBT nbt) {
        ListNBT list = (ListNBT)nbt;
        for (int i = 0; i < list.size(); ++i) {
            int index;
            Preset preset = presetMap.get(list.func_150307_f(i));
            if (preset == null || (index = presetList.indexOf(preset)) == -1) continue;
            this.presetStates[index] = true;
        }
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:preset_filter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:preset_filter.description";
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IDrawable getFilterIcon() {
        return GuiTextures.PRESET_FILTER_ICON;
    }

    @Override
    public String getOptionLangKey(int option) {
        return "filter.refinedrelocation:preset_filter.option_" + presetList.get(option).getId();
    }

    @Override
    public void setOptionChecked(int option, boolean checked) {
        this.presetStates[option] = checked;
    }

    @Override
    public boolean isOptionChecked(int option) {
        return this.presetStates[option];
    }

    @Override
    public int getOptionCount() {
        return presetMap.size();
    }

    @Override
    public int getVisualOrder() {
        return 1000;
    }

    @Override
    @Nullable
    public INamedContainerProvider getConfiguration(PlayerEntity player, final TileEntity tileEntity, final int rootFilterIndex) {
        return new INamedContainerProvider(){

            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new ChecklistFilterContainer(i, playerInventory, tileEntity, rootFilterIndex, PresetFilter.this);
            }

            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("refinedrelocation:any_filter", new Object[0]);
            }
        };
    }

    @Override
    public boolean hasConfiguration() {
        return true;
    }

    static {
        PresetFilter.registerPreset(BLOCKS);
        PresetFilter.registerPreset(ORES);
        PresetFilter.registerPreset(INGOTS);
        PresetFilter.registerPreset(NUGGETS);
        PresetFilter.registerPreset(GEMS);
        PresetFilter.registerPreset(FOOD);
        PresetFilter.registerPreset(DYES);
        PresetFilter.registerPreset(UNSTACKABLE);
        PresetFilter.registerPreset(FUEL_ITEMS);
        PresetFilter.registerPreset(REPAIRABLE);
        PresetFilter.registerPreset(WEAPONS);
        PresetFilter.registerPreset(ARMORS);
        PresetFilter.registerPreset(TOOLS);
        PresetFilter.registerPreset(ENCHANTED);
        presetList.addAll(presetMap.values());
    }

    public static abstract class Preset {
        private final String id;

        public Preset(String id) {
            this.id = id;
        }

        public final String getId() {
            return this.id;
        }

        public abstract boolean passes(ItemStack var1, Collection<ResourceLocation> var2);
    }
}

