/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.block;

import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.tile.TileBlockExtender;
import net.blay09.mods.refinedrelocation.util.RelativeSide;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockExtenderBlock
extends ContainerBlock {
    private static final VoxelShape RENDER_SHAPE = VoxelShapes.func_197873_a((double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375);
    public static final String name = "block_extender";
    public static final ResourceLocation registryName = new ResourceLocation("refinedrelocation", "block_extender");

    public BlockExtenderBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(3.0f));
    }

    public VoxelShape func_196247_c(BlockState p_196247_1_, IBlockReader p_196247_2_, BlockPos p_196247_3_) {
        return RENDER_SHAPE;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.func_180633_a(world, pos, state, placer, itemStack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileBlockExtender) {
            TileBlockExtender blockExtender = (TileBlockExtender)tileEntity;
            Direction facing = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
            for (RelativeSide side : RelativeSide.values()) {
                if (side == RelativeSide.FRONT) continue;
                blockExtender.setSideMapping(side, facing);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (!world.field_72995_K) {
            TileBlockExtender tileEntity = (TileBlockExtender)world.func_175625_s(pos);
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity, writer -> {
                writer.func_179255_a(pos);
                writer.writeInt(rayTraceResult.func_216354_b().func_176745_a());
            });
        }
        return ActionResultType.SUCCESS;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext useContext) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)useContext.func_196000_l().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208155_H});
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileBlockExtender();
    }
}

