/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.block.redstone;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.server.ServerChunkProvider;

public class RedstoneBlockAccess {
    private final World world;
    private final AbstractChunkProvider chunkManager;
    private Chunk prev;
    private long prevPos;

    public RedstoneBlockAccess(World world) {
        this.world = world;
        this.chunkManager = world.func_72863_F();
        this.clear();
    }

    public BlockState getBlockState(BlockPos pos) {
        ChunkSection section;
        int z;
        int y = pos.func_177956_o();
        if (y < 0 || y >= 256) {
            return Blocks.field_150350_a.func_176223_P();
        }
        int x = pos.func_177958_n();
        Chunk chunk = this.getChunk(x >> 4, (z = pos.func_177952_p()) >> 4);
        if (chunk != null && (section = chunk.func_76587_i()[y >> 4]) != null) {
            return section.func_177485_a(x & 0xF, y & 0xF, z & 0xF);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void setBlockState(BlockPos pos, BlockState state) {
        ChunkSection section;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        Chunk chunk = this.getChunk(x >> 4, z >> 4);
        if (chunk != null && (section = chunk.func_76587_i()[y >> 4]) != null) {
            section.func_222629_a(x & 0xF, y & 0xF, z & 0xF, state);
            if (this.chunkManager instanceof ServerChunkProvider) {
                ((ServerChunkProvider)this.chunkManager).func_217217_a(pos);
            }
        }
    }

    private Chunk getChunk(int x, int z) {
        if (ChunkPos.func_77272_a((int)x, (int)z) == this.prevPos) {
            return this.prev;
        }
        this.prev = this.world.func_212866_a_(x, z);
        this.prevPos = ChunkPos.func_77272_a((int)x, (int)z);
        return this.prev;
    }

    public void clear() {
        this.prevPos = Long.MIN_VALUE;
        this.prev = null;
    }
}

