/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.structure;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DungeonBuilderLogic {
    protected String[] entrance = new String[]{"entrance_1", "entrance_2", "entrance_3", "entrance_4", "entrance_5", "entrance_6", "entrance_7", "entrance_8"};
    protected String[] end = new String[]{"deadend_1", "deadend_2", "deadend_3", "deadend_4", "deadend_5", "deadend_6", "deadend_7", "deadend_8", "coffin_1", "advice_room_1", "restroom_1", "shoutout_1", "spawner_1", "redspuzzle_1", "deathtrap_1", "keyroom_1"};
    protected String[] corner = new String[]{"corner_1", "corner_2", "corner_3", "corner_4", "corner_5", "corner_6", "corner_7", "corner_8", "redstrap_3", "longcorner_1", "longcorner_2", "longcorner_3", "longcorner_4", "longcorner_5", "skullcorner", "mazenotfound_1"};
    protected String[] hallway = new String[]{"hallway_1", "hallway_2", "hallway_3", "hallway_4", "hallway_5", "hallway_6", "advice_room_3", "tempt_1", "redstrap_2", "extrahall_1", "extrahall_2", "extrahall_3", "coalhall_1", "moohall", "mazenotfound_3"};
    protected String[] threeway = new String[]{"threeway_1", "threeway_2", "threeway_3", "threeway_4", "threeway_5", "advice_room_2", "redstrap_4", "morethree_1", "morethree_2", "morethree_3", "tetris_1", "mazenotfound_2"};
    protected String[] fourway = new String[]{"fourway_1", "fourway_2", "fourway_3", "fourway_4", "fourway_5", "fourway_6", "fourway_7", "fourway_8", "fourway_9", "combat_1", "combat_1", "redstrap_1", "disco_1"};
    public DungeonRoom[][] finalLayout = new DungeonRoom[8][8];
    public int enemyVariation1 = 0;
    public int enemyVariation2 = 0;
    protected int entranceIndex = 0;
    protected int endIndex = 0;
    protected int cornerIndex = 0;
    protected int hallwayIndex = 0;
    protected int threewayIndex = 0;
    protected int fourwayIndex = 0;
    protected Random rand;

    public DungeonBuilderLogic(long worldSeed, long chunkX, long chunkZ) {
        long newSeed = worldSeed + chunkX * chunkX * 4987142L + chunkX * 5947611L + chunkZ * chunkZ * 4392871L + chunkZ * 389711L ^ worldSeed;
        this.rand = new Random(newSeed);
        this.shuffleArray(this.entrance);
        this.shuffleArray(this.end);
        this.shuffleArray(this.corner);
        this.shuffleArray(this.hallway);
        this.shuffleArray(this.threeway);
        this.shuffleArray(this.fourway);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.finalLayout[i][j] = new DungeonRoom();
            }
        }
        this.enemyVariation1 = this.rand.nextInt(3);
        this.enemyVariation2 = this.rand.nextInt(3);
    }

    public void calculateDungeonShape(int maxNumRooms) {
        boolean allowHardRooms = maxNumRooms > 42;
        RoomType[] mazeNotFoundVariations = new RoomType[]{RoomType.THREEWAY, RoomType.CORNER, RoomType.HALLWAY};
        RoomType mazeVariationAllowed = mazeNotFoundVariations[this.rand.nextInt(3)];
        this.placeRoomShape(4, 7, this.entrance[this.entranceIndex], RoomType.ENTRANCE, Rotation.NONE);
        ++this.entranceIndex;
        int numRoomsPlaced = 1;
        ArrayList<ImmutablePair<Integer, Integer>> openings = new ArrayList<ImmutablePair<Integer, Integer>>();
        openings.add(new ImmutablePair((Object)3, (Object)7));
        openings.add(new ImmutablePair((Object)5, (Object)7));
        openings.add(new ImmutablePair((Object)4, (Object)6));
        this.shuffleArray(openings);
        while (openings.size() > 0) {
            int variation;
            ImmutablePair<Integer, Integer> roomPos = openings.remove(0);
            RoomType nextType = RoomType.END;
            Rotation nextRot = Rotation.NONE;
            boolean mustPickEndings = false;
            boolean noEndingsYet = false;
            if (this.finalLayout[(Integer)roomPos.left][(Integer)roomPos.right].hasRoom()) continue;
            boolean mustConnectNorth = this.hasOpenDoor((Integer)roomPos.left, (Integer)roomPos.right, Direction.NORTH);
            boolean mustConnectSouth = this.hasOpenDoor((Integer)roomPos.left, (Integer)roomPos.right, Direction.SOUTH);
            boolean mustConnectWest = this.hasOpenDoor((Integer)roomPos.left, (Integer)roomPos.right, Direction.WEST);
            boolean mustConnectEast = this.hasOpenDoor((Integer)roomPos.left, (Integer)roomPos.right, Direction.EAST);
            boolean cantConnectNorth = this.hasSolidWall((Integer)roomPos.left, (Integer)roomPos.right, Direction.NORTH);
            boolean cantConnectSouth = this.hasSolidWall((Integer)roomPos.left, (Integer)roomPos.right, Direction.SOUTH);
            boolean cantConnectWest = this.hasSolidWall((Integer)roomPos.left, (Integer)roomPos.right, Direction.WEST);
            boolean cantConnectEast = this.hasSolidWall((Integer)roomPos.left, (Integer)roomPos.right, Direction.EAST);
            if (numRoomsPlaced + openings.size() >= maxNumRooms) {
                mustPickEndings = true;
            } else if (numRoomsPlaced + openings.size() < maxNumRooms / 2) {
                noEndingsYet = true;
            }
            ArrayList<ImmutablePair<RoomType, Rotation>> roomPossibilities = new ArrayList<ImmutablePair<RoomType, Rotation>>(0);
            if (mustPickEndings) {
                if (mustConnectNorth && mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.FOURWAY;
                }
                if (!mustConnectNorth && mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                }
                if (mustConnectNorth && !mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.CLOCKWISE_180;
                }
                if (mustConnectNorth && mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                }
                if (mustConnectNorth && mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.CLOCKWISE_90;
                }
                if (mustConnectNorth && !mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.CORNER;
                }
                if (!mustConnectNorth && mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.CLOCKWISE_90;
                }
                if (!mustConnectNorth && mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.CLOCKWISE_180;
                }
                if (mustConnectNorth && !mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                }
                if (mustConnectNorth && mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.HALLWAY;
                }
                if (!mustConnectNorth && !mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.HALLWAY;
                    nextRot = Rotation.CLOCKWISE_90;
                }
                if (mustConnectNorth && !mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.CLOCKWISE_180;
                }
                if (!mustConnectNorth && mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                }
                if (!mustConnectNorth && !mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.CLOCKWISE_90;
                }
                if (!mustConnectNorth && !mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                }
            } else {
                if (mustConnectNorth && mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.FOURWAY;
                }
                if (!mustConnectNorth && mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    if (noEndingsYet && !cantConnectNorth) {
                        nextType = RoomType.FOURWAY;
                    }
                }
                if (mustConnectNorth && !mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.CLOCKWISE_180;
                    if (noEndingsYet && !cantConnectSouth) {
                        nextType = RoomType.FOURWAY;
                    }
                }
                if (mustConnectNorth && mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                    if (noEndingsYet && !cantConnectWest) {
                        nextType = RoomType.FOURWAY;
                    }
                }
                if (mustConnectNorth && mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.THREEWAY;
                    nextRot = Rotation.CLOCKWISE_90;
                    if (noEndingsYet && !cantConnectEast) {
                        nextType = RoomType.FOURWAY;
                    }
                }
                if (mustConnectNorth && !mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.CORNER;
                    if (!cantConnectSouth && !cantConnectWest) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                }
                if (!mustConnectNorth && mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.CLOCKWISE_90;
                    if (!cantConnectNorth && !cantConnectWest) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                }
                if (!mustConnectNorth && mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.CLOCKWISE_180;
                    if (!cantConnectNorth && !cantConnectEast) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add(new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                }
                if (mustConnectNorth && !mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.CORNER;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                    if (!cantConnectSouth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                }
                if (mustConnectNorth && mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.HALLWAY;
                    if (!cantConnectWest && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                }
                if (!mustConnectNorth && !mustConnectSouth && mustConnectWest && mustConnectEast) {
                    nextType = RoomType.HALLWAY;
                    nextRot = Rotation.CLOCKWISE_90;
                    if (!cantConnectNorth && !cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                }
                if (mustConnectNorth && !mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.CLOCKWISE_180;
                    if (!(cantConnectSouth || cantConnectWest || cantConnectEast)) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectSouth && !cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectWest && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.HALLWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                }
                if (!mustConnectNorth && mustConnectSouth && !mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    if (!(cantConnectNorth || cantConnectWest || cantConnectEast)) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectNorth && !cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectWest && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.HALLWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.CLOCKWISE_180));
                    }
                }
                if (!mustConnectNorth && !mustConnectSouth && mustConnectWest && !mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.CLOCKWISE_90;
                    if (!(cantConnectNorth || cantConnectSouth || cantConnectEast)) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                    if (!cantConnectNorth && !cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectSouth && !cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectEast) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.HALLWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.CLOCKWISE_180));
                    }
                }
                if (!mustConnectNorth && !mustConnectSouth && !mustConnectWest && mustConnectEast) {
                    nextType = RoomType.END;
                    nextRot = Rotation.COUNTERCLOCKWISE_90;
                    if (!(cantConnectNorth || cantConnectSouth || cantConnectWest)) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.FOURWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectNorth && !cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.CLOCKWISE_180));
                    }
                    if (!cantConnectNorth && !cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.COUNTERCLOCKWISE_90));
                    }
                    if (!cantConnectSouth && !cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.THREEWAY, (Object)Rotation.NONE));
                    }
                    if (!cantConnectWest) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.HALLWAY, (Object)Rotation.CLOCKWISE_90));
                    }
                    if (!cantConnectNorth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.NONE));
                    }
                    if (!cantConnectSouth) {
                        roomPossibilities.add((ImmutablePair<RoomType, Rotation>)new ImmutablePair((Object)RoomType.CORNER, (Object)Rotation.CLOCKWISE_90));
                    }
                }
            }
            if (roomPossibilities.size() > 0 && !mustPickEndings) {
                this.shuffleRoomPossibilities(roomPossibilities);
                nextType = (RoomType)((Object)roomPossibilities.get((int)0).left);
                nextRot = (Rotation)roomPossibilities.get((int)0).right;
            }
            String nextRoom = "";
            if (nextType == RoomType.FOURWAY) {
                nextRoom = this.fourway[this.fourwayIndex];
                if (nextRoom == "fourway_1" && allowHardRooms && this.rand.nextInt(2) == 1) {
                    nextRoom = "swimmaze_1";
                }
                if (nextRoom == "combat_1") {
                    variation = this.rand.nextInt(5) + 1;
                    nextRoom = nextRoom.replace("1", "" + variation);
                }
                if (nextRoom == "disco_1") {
                    variation = this.rand.nextInt(4) + 1;
                    nextRoom = nextRoom.replace("1", "" + variation);
                }
                int n = this.fourwayIndex = this.fourwayIndex == this.fourway.length - 1 ? 0 : this.fourwayIndex + 1;
            }
            if (nextType == RoomType.THREEWAY) {
                nextRoom = this.threeway[this.threewayIndex];
                if (nextRoom.contains("mazenotfound") && mazeVariationAllowed != RoomType.THREEWAY) {
                    this.threewayIndex = this.threewayIndex == this.threeway.length - 1 ? 0 : this.threewayIndex + 1;
                    nextRoom = this.threeway[this.threewayIndex];
                }
                if (nextRoom == "tetris_1") {
                    variation = this.rand.nextInt(3) + 1;
                    nextRoom = nextRoom.replace("1", "" + variation);
                }
                int n = this.threewayIndex = this.threewayIndex == this.threeway.length - 1 ? 0 : this.threewayIndex + 1;
            }
            if (nextType == RoomType.HALLWAY) {
                nextRoom = this.hallway[this.hallwayIndex];
                if (nextRoom.contains("mazenotfound") && mazeVariationAllowed != RoomType.HALLWAY) {
                    this.hallwayIndex = this.hallwayIndex == this.hallway.length - 1 ? 0 : this.hallwayIndex + 1;
                    nextRoom = this.hallway[this.hallwayIndex];
                }
                if (nextRoom == "tempt_1") {
                    variation = this.rand.nextInt(4) + 1;
                    nextRoom = nextRoom.replace("1", "" + variation);
                }
                if (nextRoom == "extrahall_3") {
                    variation = this.rand.nextInt(3) + 3;
                    nextRoom = nextRoom.replace("3", "" + variation);
                }
                if (nextRoom == "coalhall_1") {
                    variation = this.rand.nextInt(3) + 3;
                    nextRoom = nextRoom.replace("3", "" + variation);
                }
                int n = this.hallwayIndex = this.hallwayIndex == this.hallway.length - 1 ? 0 : this.hallwayIndex + 1;
            }
            if (nextType == RoomType.CORNER) {
                nextRoom = this.corner[this.cornerIndex];
                if (nextRoom.contains("mazenotfound") && mazeVariationAllowed != RoomType.CORNER) {
                    this.cornerIndex = this.cornerIndex == this.corner.length - 1 ? 0 : this.cornerIndex + 1;
                    nextRoom = this.corner[this.cornerIndex];
                }
                int n = this.cornerIndex = this.cornerIndex == this.corner.length - 1 ? 0 : this.cornerIndex + 1;
            }
            if (nextType == RoomType.END) {
                nextRoom = this.end[this.endIndex];
                if (nextRoom == "coffin_1") {
                    variation = this.rand.nextInt(5) + 1;
                    nextRoom = nextRoom.replace("1", "" + variation);
                }
                if (nextRoom == "restroom_1") {
                    variation = this.rand.nextInt(5) + 1;
                    nextRoom = nextRoom.replace("1", "" + variation);
                }
                if (nextRoom == "shoutout_1") {
                    variation = this.rand.nextInt(2) + 1;
                    nextRoom = nextRoom.replace("1", "" + variation);
                }
                if (nextRoom == "redspuzzle_1") {
                    variation = this.rand.nextInt(4) + 1;
                    nextRoom = nextRoom.replace("1", "" + variation);
                }
                if (nextRoom == "deathtrap_1") {
                    variation = this.rand.nextInt(4) + 1;
                    nextRoom = nextRoom.replace("1", "" + variation);
                }
                if (nextRoom == "keyroom_1") {
                    if (allowHardRooms) {
                        nextRoom = "keytrap_1";
                        variation = this.rand.nextInt(5) + 1;
                        nextRoom = nextRoom.replace("1", "" + variation);
                    } else {
                        variation = this.rand.nextInt(4) + 1;
                        nextRoom = nextRoom.replace("1", "" + variation);
                    }
                }
                if (nextRoom == "spawner_1") {
                    variation = this.rand.nextInt(8) + 1;
                    nextRoom = variation < 6 ? nextRoom.replace("1", "" + variation) : nextRoom.replace("1", "6");
                }
                this.endIndex = this.endIndex == this.end.length - 1 ? 0 : this.endIndex + 1;
            }
            int roomX = (Integer)roomPos.left;
            int roomZ = (Integer)roomPos.right;
            this.placeRoomShape(roomX, roomZ, nextRoom, nextType, nextRot);
            ++numRoomsPlaced;
            if (this.hasOpenDoor(roomX - 1, roomZ, Direction.EAST) && !this.finalLayout[roomX - 1][roomZ].hasRoom()) {
                openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)(roomX - 1), (Object)roomZ));
            }
            if (this.hasOpenDoor(roomX + 1, roomZ, Direction.WEST) && !this.finalLayout[roomX + 1][roomZ].hasRoom()) {
                openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)(roomX + 1), (Object)roomZ));
            }
            if (this.hasOpenDoor(roomX, roomZ - 1, Direction.SOUTH) && !this.finalLayout[roomX][roomZ - 1].hasRoom()) {
                openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)roomX, (Object)(roomZ - 1)));
            }
            if (this.hasOpenDoor(roomX, roomZ + 1, Direction.NORTH) && !this.finalLayout[roomX][roomZ + 1].hasRoom()) {
                openings.add((ImmutablePair<Integer, Integer>)new ImmutablePair((Object)roomX, (Object)(roomZ + 1)));
            }
            this.shuffleArray(openings);
        }
    }

    private boolean hasOpenDoor(int x, int z, Direction direction) {
        if (x < 0 || z < 0 || x > 7 || z > 7) {
            return false;
        }
        if (direction == Direction.NORTH && z > 0) {
            return this.finalLayout[x][z - 1].hasDoorSouth();
        }
        if (direction == Direction.SOUTH && z < 7) {
            return this.finalLayout[x][z + 1].hasDoorNorth();
        }
        if (direction == Direction.WEST && x > 0) {
            return this.finalLayout[x - 1][z].hasDoorEast();
        }
        if (direction == Direction.EAST && x < 7) {
            return this.finalLayout[x + 1][z].hasDoorWest();
        }
        return false;
    }

    private boolean hasSolidWall(int x, int z, Direction direction) {
        if (x < 0 || z < 0 || x > 7 || z > 7) {
            return true;
        }
        if (direction == Direction.NORTH && z > 0) {
            return !this.finalLayout[x][z - 1].hasDoorSouth() && this.finalLayout[x][z - 1].hasRoom();
        }
        if (direction == Direction.SOUTH && z < 7) {
            return !this.finalLayout[x][z + 1].hasDoorNorth() && this.finalLayout[x][z + 1].hasRoom();
        }
        if (direction == Direction.WEST && x > 0) {
            return !this.finalLayout[x - 1][z].hasDoorEast() && this.finalLayout[x - 1][z].hasRoom();
        }
        if (direction == Direction.EAST && x < 7) {
            return !this.finalLayout[x + 1][z].hasDoorWest() && this.finalLayout[x + 1][z].hasRoom();
        }
        return true;
    }

    public void placeRoomShape(int x, int z, String room, RoomType type, Rotation rot) {
        this.finalLayout[x][z].structure = room;
        this.finalLayout[x][z].type = type;
        this.finalLayout[x][z].rotation = rot;
    }

    private void shuffleArray(String[] array) {
        for (int i = array.length - 1; i > 0; --i) {
            int index = this.rand.nextInt(i + 1);
            String temp = array[index];
            array[index] = array[i];
            array[i] = temp;
        }
    }

    private void shuffleArray(ArrayList<ImmutablePair<Integer, Integer>> array) {
        for (int i = array.size() - 1; i > 0; --i) {
            int index = this.rand.nextInt(i + 1);
            ImmutablePair<Integer, Integer> temp = array.get(index);
            array.set(index, array.get(i));
            array.set(i, temp);
        }
    }

    private void shuffleRoomPossibilities(ArrayList<ImmutablePair<RoomType, Rotation>> array) {
        for (int i = array.size() - 1; i > 0; --i) {
            int index = this.rand.nextInt(i + 1);
            ImmutablePair<RoomType, Rotation> temp = array.get(index);
            array.set(index, array.get(i));
            array.set(i, temp);
        }
    }

    public class DungeonRoom {
        public String structure = "";
        public Rotation rotation = Rotation.NONE;
        public RoomType type = RoomType.NONE;

        DungeonRoom() {
        }

        public boolean hasRoom() {
            return this.type != RoomType.NONE;
        }

        public boolean hasDoorNorth() {
            return this.type == RoomType.FOURWAY || this.type == RoomType.ENTRANCE && this.rotation != Rotation.CLOCKWISE_180 || this.type == RoomType.THREEWAY && this.rotation != Rotation.NONE || this.type == RoomType.CORNER && this.rotation == Rotation.NONE || this.type == RoomType.CORNER && this.rotation == Rotation.COUNTERCLOCKWISE_90 || this.type == RoomType.HALLWAY && this.rotation == Rotation.NONE || this.type == RoomType.HALLWAY && this.rotation == Rotation.CLOCKWISE_180 || this.type == RoomType.END && this.rotation == Rotation.CLOCKWISE_180;
        }

        public boolean hasDoorSouth() {
            return this.type == RoomType.FOURWAY || this.type == RoomType.ENTRANCE && this.rotation != Rotation.NONE || this.type == RoomType.THREEWAY && this.rotation != Rotation.CLOCKWISE_180 || this.type == RoomType.CORNER && this.rotation == Rotation.CLOCKWISE_90 || this.type == RoomType.CORNER && this.rotation == Rotation.CLOCKWISE_180 || this.type == RoomType.HALLWAY && this.rotation == Rotation.NONE || this.type == RoomType.HALLWAY && this.rotation == Rotation.CLOCKWISE_180 || this.type == RoomType.END && this.rotation == Rotation.NONE;
        }

        public boolean hasDoorWest() {
            return this.type == RoomType.FOURWAY || this.type == RoomType.ENTRANCE && this.rotation != Rotation.CLOCKWISE_90 || this.type == RoomType.THREEWAY && this.rotation != Rotation.COUNTERCLOCKWISE_90 || this.type == RoomType.CORNER && this.rotation == Rotation.COUNTERCLOCKWISE_90 || this.type == RoomType.CORNER && this.rotation == Rotation.CLOCKWISE_180 || this.type == RoomType.HALLWAY && this.rotation == Rotation.CLOCKWISE_90 || this.type == RoomType.HALLWAY && this.rotation == Rotation.COUNTERCLOCKWISE_90 || this.type == RoomType.END && this.rotation == Rotation.CLOCKWISE_90;
        }

        public boolean hasDoorEast() {
            return this.type == RoomType.FOURWAY || this.type == RoomType.ENTRANCE && this.rotation != Rotation.COUNTERCLOCKWISE_90 || this.type == RoomType.THREEWAY && this.rotation != Rotation.CLOCKWISE_90 || this.type == RoomType.CORNER && this.rotation == Rotation.NONE || this.type == RoomType.CORNER && this.rotation == Rotation.CLOCKWISE_90 || this.type == RoomType.HALLWAY && this.rotation == Rotation.CLOCKWISE_90 || this.type == RoomType.HALLWAY && this.rotation == Rotation.COUNTERCLOCKWISE_90 || this.type == RoomType.END && this.rotation == Rotation.COUNTERCLOCKWISE_90;
        }
    }

    static enum RoomType {
        ENTRANCE,
        END,
        CORNER,
        HALLWAY,
        THREEWAY,
        FOURWAY,
        NONE;

    }
}

