/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.block;

import com.catastrophe573.dimdungeons.block.BlockRegistrar;
import com.catastrophe573.dimdungeons.block.TileEntityPortalKeyhole;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPortalKeyhole
extends Block {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty FILLED = BooleanProperty.func_177716_a((String)"filled");
    public static final BooleanProperty LIT = BooleanProperty.func_177716_a((String)"lit");
    public static final String REG_NAME = "block_portal_keyhole";

    public BlockPortalKeyhole() {
        super(Block.Properties.func_200945_a((Material)Material.field_151567_E).func_200943_b(2.0f).func_200947_a(SoundType.field_185852_e));
        this.setRegistryName("dimdungeons", REG_NAME);
        this.func_180632_j(this.getMyCustomDefaultState());
    }

    public BlockState getMyCustomDefaultState() {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        boolean hasPortalBlockBelow;
        boolean bl = hasPortalBlockBelow = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == BlockRegistrar.block_gold_portal;
        if (((Boolean)stateIn.func_177229_b((IProperty)LIT)).booleanValue() && hasPortalBlockBelow) {
            Direction enumfacing = (Direction)stateIn.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187810_eg, SoundCategory.BLOCKS, 1.0f, 3.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0 - 0.52, d1, d2 + d4, -1.0, 1.0, 0.0);
                    break;
                }
                case EAST: {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0 + 0.52, d1, d2 + d4, 1.0, 1.0, 0.0);
                    break;
                }
                case NORTH: {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0 + d4, d1, d2 - 0.52, 0.0, 1.0, -1.0);
                    break;
                }
                default: {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d0 + d4, d1, d2 + 0.52, 0.0, 1.0, 1.0);
                }
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack playerItem = player.func_184586_b(handIn);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        TileEntityPortalKeyhole myEntity = (TileEntityPortalKeyhole)tileEntity;
        if (myEntity != null) {
            ItemStack insideItem = myEntity.getObjectInserted();
            if (insideItem.func_190926_b()) {
                if (!playerItem.func_190926_b()) {
                    myEntity.setContents(playerItem.func_77946_l());
                    playerItem.func_190918_g(1);
                    BlockState newBlockState = (BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)FILLED, (Comparable)Boolean.valueOf(myEntity.isFilled()))).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(myEntity.isActivated()));
                    worldIn.func_175656_a(pos, newBlockState);
                    if (this.isOkayToSpawnPortalBlocks(worldIn, pos, state, myEntity)) {
                        worldIn.func_175656_a(pos.func_177977_b(), BlockRegistrar.block_gold_portal.func_176223_P());
                        worldIn.func_175656_a(pos.func_177979_c(2), BlockRegistrar.block_gold_portal.func_176223_P());
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (playerItem.func_190926_b()) {
                    player.func_184611_a(handIn, insideItem);
                } else if (!player.func_191521_c(insideItem)) {
                    player.func_71019_a(insideItem, false);
                }
                myEntity.removeContents();
                BlockState newBlockState = (BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)FILLED, (Comparable)Boolean.valueOf(myEntity.isFilled()))).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(myEntity.isActivated()));
                worldIn.func_180501_a(pos, newBlockState, 3);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    protected boolean isOkayToSpawnPortalBlocks(World worldIn, BlockPos pos, BlockState state, TileEntityPortalKeyhole myEntity) {
        if (!myEntity.isActivated()) {
            return false;
        }
        Block b1 = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block b2 = worldIn.func_180495_p(pos.func_177979_c(2)).func_177230_c();
        if (b1 != Blocks.field_150350_a && b1 != BlockRegistrar.block_gold_portal) {
            return false;
        }
        if (b2 != Blocks.field_150350_a && b2 != BlockRegistrar.block_gold_portal) {
            return false;
        }
        ItemStack item = myEntity.getObjectInserted();
        if (item.func_77973_b() instanceof ItemPortalKey) {
            ItemPortalKey key = (ItemPortalKey)item.func_77973_b();
            return key.isActivated(item);
        }
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityPortalKeyhole();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState retval = this.getMyCustomDefaultState();
        return (BlockState)retval.func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (state.func_177230_c() != newState.func_177230_c()) {
            if (tileentity instanceof TileEntityPortalKeyhole) {
                ItemStack item = ((TileEntityPortalKeyhole)tileentity).getObjectInserted();
                if (!item.func_190926_b()) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)item);
                }
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            worldIn.func_175713_t(pos);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Boolean)blockState.func_177229_b((IProperty)FILLED) != false ? 1 : 0;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)this);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockState getExtendedState(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState retval = state;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityPortalKeyhole) {
            retval.func_206870_a((IProperty)FILLED, (Comparable)Boolean.valueOf(((TileEntityPortalKeyhole)te).isFilled()));
            retval.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(((TileEntityPortalKeyhole)te).isActivated()));
        }
        return retval;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, FILLED, LIT});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((Direction)state.func_177229_b((IProperty)FACING)));
    }
}

