/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.client.core.handler.BaubleRenderHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class ItemBaubleCosmetic
extends ItemBauble
implements ICosmeticBauble {
    private final Variant variant;
    public static final int SUBTYPES = Variant.values().length;

    public ItemBaubleCosmetic(Variant variant, Item.Properties props) {
        super(props);
        this.variant = variant;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<ITextComponent> stacks, ITooltipFlag flags) {
        if (this.variant == Variant.THINKING_HAND) {
            stacks.add(new TranslationTextComponent("botaniamisc.cosmeticThinking", new Object[0]).func_211708_a(TextFormatting.GRAY));
        } else {
            stacks.add(new TranslationTextComponent("botaniamisc.cosmeticBauble", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        super.addHiddenTooltip(stack, world, stacks, flags);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void doRender(BaubleRenderHandler layer, ItemStack stack, LivingEntity player, MatrixStack ms, IRenderTypeBuffer buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Variant variant = ((ItemBaubleCosmetic)stack.func_77973_b()).variant;
        if (variant.isHead) {
            ((PlayerModel)layer.func_215332_c()).field_78116_c.func_228307_a_(ms);
            switch (variant) {
                case RED_GLASSES: 
                case ENGINEER_GOGGLES: 
                case ANAGLYPH_GLASSES: {
                    ms.func_227861_a_(0.0, -0.225, -0.3);
                    ms.func_227862_a_(0.7f, -0.7f, -0.7f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case EYEPATCH: {
                    ms.func_227861_a_(0.125, -0.225, -0.3);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    ms.func_227862_a_(0.3f, -0.3f, -0.3f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case WICKED_EYEPATCH: {
                    ms.func_227861_a_(-0.125, -0.225, -0.3);
                    ms.func_227862_a_(0.3f, -0.3f, -0.3f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case RED_RIBBONS: {
                    ms.func_227861_a_(0.0, -0.65, 0.2);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case PINK_FLOWER_BUD: {
                    ms.func_227861_a_(0.275, -0.6, 0.0);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case POLKA_DOTTED_BOWS: {
                    ms.func_227860_a_();
                    ms.func_227861_a_(0.275, -0.4, 0.0);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    ms.func_227865_b_();
                    ms.func_227861_a_(-0.275, -0.4, 0.0);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case BLUE_BUTTERFLY: {
                    ms.func_227860_a_();
                    ms.func_227861_a_(0.275, -0.4, 0.0);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    ms.func_227865_b_();
                    ms.func_227861_a_(0.275, -0.4, 0.0);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-45.0f));
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case CAT_EARS: {
                    ms.func_227861_a_(0.0, -0.5, (double)-0.175f);
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case GOOGLY_EYES: {
                    ms.func_227861_a_(0.0, -0.225, -0.3);
                    ms.func_227862_a_(0.9f, -0.9f, -0.9f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case CLOCK_EYE: {
                    ms.func_227861_a_(0.1, -0.225, (double)-0.3f);
                    ms.func_227862_a_(0.4f, -0.4f, -0.4f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case UNICORN_HORN: {
                    ms.func_227861_a_(0.0, -0.7, -0.3);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                    ms.func_227862_a_(0.6f, -0.6f, -0.6f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case DEVIL_HORNS: {
                    ms.func_227861_a_(0.0, (double)-0.4f, (double)-0.175f);
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case HYPER_PLUS: {
                    ms.func_227861_a_((double)-0.15f, (double)-0.45f, (double)-0.3f);
                    ms.func_227862_a_(0.2f, -0.2f, -0.2f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    ms.func_227861_a_((double)1.45f, 0.0, 0.0);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case ANCIENT_MASK: {
                    ms.func_227861_a_(0.0, -0.3, -0.3);
                    ms.func_227862_a_(0.7f, -0.7f, -0.7f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case EERIE_MASK: {
                    ms.func_227861_a_(0.0, -0.25, -0.3);
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case ALIEN_ANTENNA: {
                    ms.func_227861_a_(0.0, -0.65, 0.2);
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case ORANGE_SHADES: {
                    ms.func_227861_a_(0.0, -0.3, -0.3);
                    ms.func_227862_a_(0.7f, -0.7f, -0.7f);
                    int color = -1291845633;
                    RenderHelper.renderItemCustomColor(player, stack, color, ms, buffers, light, OverlayTexture.field_229196_a_);
                    break;
                }
                case GROUCHO_GLASSES: {
                    ms.func_227861_a_(0.0, -0.1, -0.3);
                    ms.func_227862_a_(0.75f, -0.75f, -0.75f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case THICK_EYEBROWS: {
                    ms.func_227860_a_();
                    ms.func_227861_a_(-0.1, -0.3, -0.3);
                    ms.func_227862_a_(0.3f, -0.3f, -0.3f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    ms.func_227865_b_();
                    ms.func_227861_a_(0.1, -0.3, -0.3);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    ms.func_227862_a_(0.3f, -0.3f, -0.3f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case TINY_POTATO_MASK: {
                    ms.func_227861_a_(0.0, -0.3, -0.3);
                    ms.func_227862_a_(0.6f, -0.6f, -0.6f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case QUESTGIVER_MARK: {
                    ms.func_227861_a_(0.0, -0.8, -0.2);
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case THINKING_HAND: {
                    ms.func_227861_a_(-0.1, 0.0, -0.3);
                    ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-15.0f));
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
            }
        } else {
            ((PlayerModel)layer.func_215332_c()).field_78115_e.func_228307_a_(ms);
            switch (variant) {
                case BLACK_BOWTIE: {
                    ms.func_227861_a_(0.0, 0.1, -0.13);
                    ms.func_227862_a_(0.6f, -0.6f, -0.6f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case BLACK_TIE: 
                case PUFFY_SCARF: {
                    ms.func_227861_a_(0.0, 0.25, -0.15);
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case WITCH_PIN: {
                    ms.func_227861_a_(-0.1, 0.15, -0.15);
                    ms.func_227862_a_(0.2f, -0.2f, -0.2f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case DEVIL_TAIL: {
                    ms.func_227861_a_(0.0, 0.55, 0.2);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
                    ms.func_227862_a_(0.6f, -0.6f, -0.6f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case KAMUI_EYE: {
                    ms.func_227860_a_();
                    ms.func_227861_a_(0.4, 0.1, -0.2);
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    ms.func_227865_b_();
                    ms.func_227861_a_(-0.4, 0.1, -0.2);
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    ms.func_227862_a_(0.5f, -0.5f, -0.5f);
                    RenderHelper.renderItemCustomColor(player, stack, -16777140, ms, buffers, light, OverlayTexture.field_229196_a_);
                    break;
                }
                case FOUR_LEAF_CLOVER: {
                    ms.func_227861_a_(0.1, 0.1, -0.13);
                    ms.func_227862_a_(0.3f, -0.3f, -0.3f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case BOTANIST_EMBLEM: {
                    ms.func_227861_a_(0.0, 0.375, -0.13);
                    ms.func_227862_a_(0.3f, -0.3f, -0.3f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
                case LUSITANIC_SHIELD: {
                    ms.func_227861_a_(0.0, 0.35, 0.13);
                    ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(8.0f));
                    ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                    ms.func_227862_a_(0.6f, -0.6f, -0.6f);
                    ItemBaubleCosmetic.renderItem(stack, ms, buffers, light);
                    break;
                }
            }
        }
    }

    public static void renderItem(ItemStack stack, MatrixStack ms, IRenderTypeBuffer buffers, int light) {
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.NONE, light, OverlayTexture.field_229196_a_, ms, buffers);
    }

    public static enum Variant {
        BLACK_BOWTIE,
        BLACK_TIE,
        RED_GLASSES(true),
        PUFFY_SCARF,
        ENGINEER_GOGGLES(true),
        EYEPATCH(true),
        WICKED_EYEPATCH(true),
        RED_RIBBONS(true),
        PINK_FLOWER_BUD(true),
        POLKA_DOTTED_BOWS(true),
        BLUE_BUTTERFLY(true),
        CAT_EARS(true),
        WITCH_PIN,
        DEVIL_TAIL,
        KAMUI_EYE,
        GOOGLY_EYES(true),
        FOUR_LEAF_CLOVER,
        CLOCK_EYE(true),
        UNICORN_HORN(true),
        DEVIL_HORNS(true),
        HYPER_PLUS(true),
        BOTANIST_EMBLEM,
        ANCIENT_MASK(true),
        EERIE_MASK(true),
        ALIEN_ANTENNA(true),
        ANAGLYPH_GLASSES(true),
        ORANGE_SHADES(true),
        GROUCHO_GLASSES(true),
        THICK_EYEBROWS(true),
        LUSITANIC_SHIELD,
        TINY_POTATO_MASK(true),
        QUESTGIVER_MARK(true),
        THINKING_HAND(true);

        private final boolean isHead;

        private Variant(boolean isHead) {
            this.isHead = isHead;
        }

        private Variant() {
            this(false);
        }
    }
}

