/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;
import vazkii.botania.common.block.BlockMod;
import vazkii.botania.common.block.tile.TileHourglass;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.item.ModItems;

public class BlockHourglass
extends BlockMod
implements IManaTrigger,
IWandable,
IWandHUD {
    private static final VoxelShape SHAPE = BlockHourglass.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)18.4, (double)12.0);

    protected BlockHourglass(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208194_u});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileHourglass hourglass = (TileHourglass)world.func_175625_s(pos);
        ItemStack hgStack = hourglass.getItemHandler().getStackInSlot(0);
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b() && stack.func_77973_b() == ModItems.twigWand) {
            return ActionResultType.PASS;
        }
        if (hourglass.lock) {
            if (!player.field_70170_p.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("botaniamisc.hourglassLock", new Object[0]));
            }
            return ActionResultType.FAIL;
        }
        if (hgStack.func_190926_b() && TileHourglass.getStackItemTime(stack) > 0) {
            hourglass.getItemHandler().setStackInSlot(0, stack.func_77946_l());
            hourglass.func_70296_d();
            stack.func_190920_e(0);
            return ActionResultType.SUCCESS;
        }
        if (!hgStack.func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)hgStack);
            hourglass.getItemHandler().setStackInSlot(0, ItemStack.field_190927_a);
            hourglass.func_70296_d();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u) != false ? 15 : 0;
    }

    public int func_149738_a(IWorldReader world) {
        return 4;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
            InventoryHelper.dropInventory(inv, world, state, pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull BlockState state, @Nonnull IBlockReader world) {
        return new TileHourglass();
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        if (!burst.isFake()) {
            TileHourglass tile = (TileHourglass)world.func_175625_s(pos);
            tile.onManaCollide();
        }
    }

    @Override
    public boolean onUsedByWand(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Direction side) {
        TileHourglass tile = (TileHourglass)world.func_175625_s(pos);
        boolean bl = tile.lock = !tile.lock;
        if (!world.field_72995_K) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(Minecraft mc, World world, BlockPos pos) {
        TileHourglass tile = (TileHourglass)world.func_175625_s(pos);
        tile.renderHUD();
    }
}

