/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.mana;

import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.LazyValue;
import org.apache.logging.log4j.LogManager;

public interface ManaItemHandler {
    public static final LazyValue<ManaItemHandler> INSTANCE = new LazyValue(() -> {
        try {
            return (ManaItemHandler)Class.forName("vazkii.botania.common.impl.mana.ManaItemHandlerImpl").newInstance();
        }
        catch (ReflectiveOperationException e) {
            LogManager.getLogger().warn("Unable to find ManaItemHandlerImpl, using a dummy");
            return new ManaItemHandler(){};
        }
    });

    public static ManaItemHandler instance() {
        return (ManaItemHandler)INSTANCE.func_179281_c();
    }

    default public List<ItemStack> getManaItems(PlayerEntity player) {
        return Collections.emptyList();
    }

    default public List<ItemStack> getManaAccesories(PlayerEntity player) {
        return Collections.emptyList();
    }

    default public int requestMana(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        return 0;
    }

    default public boolean requestManaExact(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        return false;
    }

    default public int dispatchMana(ItemStack stack, PlayerEntity player, int manaToSend, boolean add) {
        return 0;
    }

    default public boolean dispatchManaExact(ItemStack stack, PlayerEntity player, int manaToSend, boolean add) {
        return false;
    }

    default public int requestManaForTool(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        return 0;
    }

    default public boolean requestManaExactForTool(ItemStack stack, PlayerEntity player, int manaToGet, boolean remove) {
        return false;
    }

    default public float getFullDiscountForTools(PlayerEntity player, ItemStack tool) {
        return 0.0f;
    }
}

