/*
 * Decompiled with CFR 0.152.
 */
package me.dags.noise.selector;

import me.dags.noise.Module;
import me.dags.noise.func.Interpolation;
import me.dags.noise.selector.Selector;

public class Select
extends Selector {
    protected final Module control;
    protected final Module source0;
    protected final Module source1;
    protected final float lowerBound;
    protected final float upperBound;
    protected final float edgeFalloff;
    protected final float lowerCurveMin;
    protected final float lowerCurveMax;
    protected final float lowerCurveRange;
    protected final float upperCurveMin;
    protected final float upperCurveMax;
    protected final float upperCurveRange;

    public Select(Module control, Module source0, Module source1, float lowerBound, float upperBound, float edgeFalloff, Interpolation interpolation) {
        super(control, new Module[]{source0, source1}, interpolation);
        this.control = control;
        this.source0 = source0;
        this.source1 = source1;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.edgeFalloff = edgeFalloff;
        this.lowerCurveMin = lowerBound - edgeFalloff;
        this.lowerCurveMax = lowerBound + edgeFalloff;
        this.lowerCurveRange = this.lowerCurveMax - this.lowerCurveMin;
        this.upperCurveMin = upperBound - edgeFalloff;
        this.upperCurveMax = upperBound + edgeFalloff;
        this.upperCurveRange = this.upperCurveMax - this.upperCurveMin;
    }

    @Override
    public float selectValue(float x, float y, float value) {
        if (this.edgeFalloff == 0.0f) {
            if (value < this.lowerCurveMax) {
                return this.source0.getValue(x, y);
            }
            if (value > this.upperCurveMin) {
                return this.source1.getValue(x, y);
            }
            return this.source0.getValue(x, y);
        }
        if (value < this.lowerCurveMin) {
            return this.source0.getValue(x, y);
        }
        if (value < this.lowerCurveMax) {
            float alpha = (value - this.lowerCurveMin) / this.lowerCurveRange;
            return this.blendValues(this.source0.getValue(x, y), this.source1.getValue(x, y), alpha);
        }
        if (value < this.upperCurveMin) {
            return this.source1.getValue(x, y);
        }
        if (value < this.upperCurveMax) {
            float alpha = (value - this.upperCurveMin) / this.upperCurveRange;
            return this.blendValues(this.source1.getValue(x, y), this.source0.getValue(x, y), alpha);
        }
        return this.source0.getValue(x, y);
    }
}

