/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.terraforged.mod.Log;
import com.terraforged.mod.settings.TerraSettings;
import com.terraforged.mod.util.nbt.NBTHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;
import net.minecraft.world.storage.WorldInfo;

public class SettingsHelper {
    public static final String SETTINGS_FILE_NAME = "terraforged-generator.json";
    public static final File SETTINGS_DIR = new File("config", "terraforged");
    public static final File SETTINGS_FILE = new File(SETTINGS_DIR, "terraforged-generator.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static int getVersion(WorldInfo info) {
        if (info.func_211027_A().isEmpty()) {
            return 1;
        }
        CompoundNBT version = info.func_211027_A().func_74775_l("version");
        if (version.isEmpty()) {
            return 0;
        }
        return version.func_74762_e("value");
    }

    public static void clearDefaults() {
        if (SETTINGS_FILE.exists() && SETTINGS_FILE.delete()) {
            Log.info("Deleted generator defaults", new Object[0]);
        }
    }

    public static void exportDefaults(TerraSettings settings) {
        CompoundNBT tag = NBTHelper.serializeCompact(settings);
        JsonElement json = NBTHelper.toJson(tag);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(SETTINGS_FILE));){
            GSON.toJson(json, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void applyDefaults(CompoundNBT options, TerraSettings dest) {
        if (options.isEmpty()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(SETTINGS_FILE));){
                JsonElement json = new JsonParser().parse((Reader)reader);
                options = NBTHelper.fromJson(json);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        NBTHelper.deserialize(options, dest);
    }

    public static TerraSettings getSettings(IWorld world) {
        TerraSettings settings = new TerraSettings();
        if (world.func_72912_H().func_211027_A().isEmpty()) {
            if (SETTINGS_FILE.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(SETTINGS_FILE));){
                    Log.info("Loading generator settings from json", new Object[0]);
                    JsonElement json = new JsonParser().parse((Reader)reader);
                    CompoundNBT root = NBTHelper.fromJson(json);
                    NBTHelper.deserialize(root, settings);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        } else {
            Log.info("Loading generator settings from level.dat", new Object[0]);
            NBTHelper.deserialize(world.func_72912_H().func_211027_A(), settings);
        }
        return settings;
    }

    public static void syncSettings(WorldInfo info, TerraSettings settings, int version) {
        settings.version = version;
        settings.generator.seed = info.func_76063_b();
        CompoundNBT options = NBTHelper.serialize(settings);
        info.func_212242_b(options);
    }

    public static void moveSettings() {
        if (SETTINGS_FILE.exists()) {
            return;
        }
        File src = new File("config", SETTINGS_FILE_NAME);
        if (src.exists() && (SETTINGS_DIR.exists() || SETTINGS_DIR.mkdirs())) {
            try {
                Files.copy(src.toPath(), SETTINGS_FILE.toPath(), new CopyOption[0]);
                if (src.delete()) {
                    Log.info("Moved settings file to new location: {}", SETTINGS_FILE.getAbsoluteFile());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

