/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.gui;

import com.terraforged.mod.gui.OverlayRenderer;
import com.terraforged.mod.gui.element.Element;
import com.terraforged.mod.gui.preview.Preview;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.AbstractOptionList;

public class ScrollPane
extends AbstractOptionList<Entry>
implements OverlayRenderer {
    private boolean hovered = false;

    public ScrollPane(int slotHeightIn) {
        super(Minecraft.func_71410_x(), 0, 0, 0, 0, slotHeightIn);
    }

    public void addButton(Widget button) {
        super.addEntry((AbstractList.AbstractListEntry)new Entry(button));
    }

    @Override
    public void renderOverlays(Screen screen, int x, int y) {
        for (Entry entry : this.children()) {
            Widget button;
            if (!entry.isMouseOver(x, y) || !entry.option.isMouseOver((double)x, (double)y) || !((button = entry.option) instanceof Element)) continue;
            screen.renderTooltip(((Element)button).getTooltip(), x, y);
            return;
        }
    }

    public int getRowWidth() {
        return this.width - 20;
    }

    public void render(int x, int y, float partialTicks) {
        super.render(x, y, partialTicks);
        this.hovered = this.isMouseOver(x, y);
    }

    protected int getScrollbarPosition() {
        return this.getRight();
    }

    public boolean mouseScrolled(double x, double y, double direction) {
        return this.hovered && super.mouseScrolled(x, y, direction);
    }

    public class Entry
    extends AbstractOptionList.Entry<Entry> {
        public final Widget option;

        public Entry(Widget option) {
            this.option = option;
        }

        public List<? extends IGuiEventListener> children() {
            return Collections.singletonList(this.option);
        }

        public boolean mouseClicked(double x, double y, int button) {
            return this.option.mouseClicked(x, y, button);
        }

        public boolean mouseReleased(double x, double y, int button) {
            return this.option.mouseReleased(x, y, button);
        }

        public void render(int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean wut, float partialTicks) {
            int optionWidth = Math.min(396, width);
            int padding = (width - optionWidth) / 2;
            this.option.x = left + padding;
            this.option.y = top;
            this.option.visible = true;
            this.option.setWidth(optionWidth);
            this.option.setHeight(height - 1);
            if (this.option instanceof Preview) {
                this.option.setHeight(this.option.getWidth());
            }
            this.option.render(mouseX, mouseY, partialTicks);
        }
    }
}

