/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.decorator.feature;

import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.api.material.layer.LayerManager;
import com.terraforged.api.material.layer.LayerMaterial;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.world.heightmap.Levels;
import com.terraforged.mod.material.MaterialHelper;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.IChunk;

public class LayerDecorator
implements ColumnDecorator {
    private final LayerManager layerManager;

    public LayerDecorator(LayerManager layerManager) {
        this.layerManager = layerManager;
    }

    @Override
    public void decorate(IChunk chunk, DecoratorContext context, int x, int y, int z) {
        context.pos.func_181079_c(x, y + 1, z);
        BlockState state = chunk.func_180495_p((BlockPos)context.pos);
        LayerMaterial material = this.layerManager.getMaterial(state.func_177230_c());
        if (material != null) {
            this.setLayer(chunk, (BlockPos)context.pos, material, context.cell, context.levels, 0.0f);
            return;
        }
        if (MaterialHelper.isAir(state.func_177230_c())) {
            return;
        }
        if (state.func_185904_a().func_76230_c() || !chunk.func_180495_p((BlockPos)context.pos.func_181079_c(x, y, z)).func_185904_a().func_76230_c() || MaterialHelper.isAir(chunk.func_180495_p((BlockPos)context.pos.func_181079_c(x, y + 2, z)).func_177230_c())) {
            // empty if block
        }
    }

    private void setLayer(IChunk chunk, BlockPos pos, LayerMaterial material, Cell<?> cell, Levels levels, float min) {
        float height = cell.value * (float)levels.worldHeight;
        float depth = material.getDepth(height);
        if (depth > min) {
            int level = material.getLevel(depth);
            BlockState layer = material.getState(level);
            if (MaterialHelper.isAir(layer.func_177230_c())) {
                return;
            }
            chunk.func_177436_a(pos, layer, false);
        }
    }
}

