/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.command.arg;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeArgType
implements ArgumentType<Biome> {
    public Biome parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String raw = reader.getString().substring(cursor);
        if (raw.indexOf(58) == -1) {
            reader.setCursor(cursor);
            throw BiomeArgType.createException("Invalid biome", "%s is not a valid biome", raw);
        }
        ResourceLocation resourcelocation = ResourceLocation.func_208304_a((String)raw);
        if (resourcelocation == null) {
            reader.setCursor(cursor);
            throw BiomeArgType.createException("Invalid biome", "%s is not a valid biome", raw);
        }
        if (!ForgeRegistries.BIOMES.containsKey(resourcelocation)) {
            reader.setCursor(cursor);
            throw BiomeArgType.createException("Invalid biome", "%s is not a valid biome", resourcelocation);
        }
        reader.setCursor(reader.getString().length());
        return (Biome)ForgeRegistries.BIOMES.getValue(resourcelocation);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder suggestions) {
        return ISuggestionProvider.func_197014_a((Iterable)ForgeRegistries.BIOMES.getKeys(), (SuggestionsBuilder)suggestions);
    }

    private static CommandSyntaxException createException(String type, String message, Object ... args) {
        return new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)new StringTextComponent(type)), (Message)new StringTextComponent(String.format(message, args)));
    }

    public static ArgumentType<Biome> biome() {
        return new BiomeArgType();
    }

    public static <S> Biome getBiome(CommandContext<S> context, String name) {
        return (Biome)context.getArgument(name, Biome.class);
    }

    public static class Serializer
    implements IArgumentSerializer<BiomeArgType> {
        public void write(BiomeArgType type, PacketBuffer buffer) {
        }

        public BiomeArgType read(PacketBuffer buffer) {
            return new BiomeArgType();
        }

        public void write(BiomeArgType type, JsonObject json) {
        }
    }
}

