/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.chunk;

import com.terraforged.api.chunk.column.ColumnDecorator;
import com.terraforged.api.chunk.column.DecoratorContext;
import com.terraforged.api.chunk.surface.ChunkSurfaceBuffer;
import com.terraforged.api.chunk.surface.SurfaceContext;
import com.terraforged.api.chunk.surface.SurfaceManager;
import com.terraforged.api.material.layer.LayerManager;
import com.terraforged.core.cell.Cell;
import com.terraforged.core.region.Size;
import com.terraforged.core.region.chunk.ChunkReader;
import com.terraforged.core.region.gen.RegionCache;
import com.terraforged.core.region.gen.RegionGenerator;
import com.terraforged.core.util.concurrent.ThreadPool;
import com.terraforged.core.world.decorator.Decorator;
import com.terraforged.core.world.terrain.Terrain;
import com.terraforged.feature.FeatureManager;
import com.terraforged.feature.matcher.dynamic.DynamicMatcher;
import com.terraforged.feature.matcher.feature.FeatureMatcher;
import com.terraforged.feature.modifier.FeatureModifierLoader;
import com.terraforged.feature.modifier.FeatureModifiers;
import com.terraforged.feature.predicate.DeepWater;
import com.terraforged.feature.predicate.FeaturePredicate;
import com.terraforged.feature.predicate.MinDepth;
import com.terraforged.feature.predicate.MinHeight;
import com.terraforged.feature.template.type.FeatureTypes;
import com.terraforged.mod.Log;
import com.terraforged.mod.biome.provider.BiomeProvider;
import com.terraforged.mod.chunk.ChunkProcessor;
import com.terraforged.mod.chunk.FastChunk;
import com.terraforged.mod.chunk.ObfHelperChunkGenerator;
import com.terraforged.mod.chunk.TerraContainer;
import com.terraforged.mod.chunk.TerraContext;
import com.terraforged.mod.chunk.fix.ChunkCarverFix;
import com.terraforged.mod.chunk.fix.RegionFix;
import com.terraforged.mod.decorator.ChunkPopulator;
import com.terraforged.mod.decorator.base.BedrockDecorator;
import com.terraforged.mod.decorator.base.CoastDecorator;
import com.terraforged.mod.decorator.base.ErosionDecorator;
import com.terraforged.mod.decorator.base.GeologyDecorator;
import com.terraforged.mod.decorator.feature.LayerDecorator;
import com.terraforged.mod.decorator.feature.SnowEroder;
import com.terraforged.mod.decorator.surface.FrozenOcean;
import com.terraforged.mod.feature.Matchers;
import com.terraforged.mod.feature.TerrainHelper;
import com.terraforged.mod.feature.predicate.TreeLine;
import com.terraforged.mod.material.Materials;
import com.terraforged.mod.material.geology.GeoManager;
import com.terraforged.mod.util.Environment;
import com.terraforged.mod.util.setup.SetupHooks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class TerraChunkGenerator
extends ObfHelperChunkGenerator<GenerationSettings>
implements ChunkProcessor {
    private final TerraContext context;
    private final BiomeProvider biomeProvider;
    private final TerrainHelper terrainHelper;
    private final GeoManager geologyManager;
    private final FeatureManager featureManager;
    private final SurfaceManager surfaceManager;
    private final List<ColumnDecorator> baseDecorators;
    private final List<ColumnDecorator> postProcessors;
    private final RegionCache regionCache;

    public TerraChunkGenerator(TerraContext context, BiomeProvider biomeProvider, GenerationSettings settings) {
        super(context.world, biomeProvider, settings);
        this.context = context;
        this.biomeProvider = biomeProvider;
        this.surfaceManager = SetupHooks.setup(this.createSurfaceManager(), context.copy());
        this.geologyManager = SetupHooks.setup(this.createGeologyManager(context), context.copy());
        this.baseDecorators = this.createBaseDecorators(context);
        this.postProcessors = this.createFeatureDecorators(context);
        this.terrainHelper = new TerrainHelper(0.75f);
        this.featureManager = this.createFeatureManager(context);
        this.regionCache = this.createRegionCache(context);
        SetupHooks.setup(this.getLayerManager(), context.copy());
        SetupHooks.setup(this.baseDecorators, this.postProcessors, context.copy());
    }

    public void func_227058_a_(BiomeManager biomes, IChunk chunk, ChunkGenerator<?> generator, TemplateManager templates) {
        ChunkPos pos = chunk.func_76632_l();
        int regionX = this.regionCache.chunkToRegion(pos.field_77276_a);
        int regionZ = this.regionCache.chunkToRegion(pos.field_77275_b);
        this.regionCache.queueRegion(regionX, regionZ);
        super.func_227058_a_(biomes, chunk, (ChunkGenerator)this, templates);
    }

    public final void func_222539_a(IChunk chunk) {
        ChunkPos pos = chunk.func_76632_l();
        ChunkReader reader = this.getChunkReader(pos.field_77276_a, pos.field_77275_b);
        TerraContainer container = this.getBiomeProvider().createBiomeContainer(reader);
        ((ChunkPrimer)chunk).func_225548_a_((BiomeContainer)container);
        this.preProcess(pos, reader, container);
    }

    @Override
    public final void preProcess(ChunkPos pos, ChunkReader chunk, TerraContainer container) {
        chunk.iterate((cell, dx, dz) -> {
            Biome biome = container.getBiome(dx, dz);
            for (Decorator decorator : this.getBiomeProvider().getDecorators(biome)) {
                if (!decorator.apply(cell, pos.func_180334_c() + dx, pos.func_180333_d() + dz)) continue;
                return;
            }
        });
    }

    @Override
    public final void generateBase(IWorld world, IChunk chunk) {
        TerraContainer container = this.getBiomeContainer(chunk);
        DecoratorContext context = new DecoratorContext(FastChunk.wrap(chunk), this.getContext().levels, this.getContext().terrain, this.getContext().factory.getClimate());
        container.getChunkReader().iterate(context, (cell, dx, dz, ctx) -> {
            int px = ctx.blockX + dx;
            int pz = ctx.blockZ + dz;
            int py = ctx.levels.scale(cell.value);
            ctx.cell = cell;
            ctx.biome = container.getBiome(dx, dz);
            ChunkPopulator.INSTANCE.decorate(ctx.chunk, (DecoratorContext)ctx, px, py, pz);
        });
        this.terrainHelper.flatten(world, chunk);
    }

    @Override
    public final void generateSurface(WorldGenRegion world, IChunk chunk) {
        TerraContainer container = this.getBiomeContainer(chunk);
        ChunkSurfaceBuffer buffer = new ChunkSurfaceBuffer(FastChunk.wrap(chunk));
        SurfaceContext context = this.getContext().surface(buffer, this.func_201496_a_());
        container.getChunkReader().iterate(context, (cell, dx, dz, ctx) -> {
            int px = ctx.blockX + dx;
            int pz = ctx.blockZ + dz;
            int top = ctx.chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, dx, dz) + 1;
            ctx.buffer.setSurfaceLevel(top);
            ctx.cell = cell;
            ctx.biome = container.getBiome(dx, dz);
            ctx.noise = this.getSurfaceNoise(px, pz) * 15.0;
            this.getSurfaceManager().getSurface((SurfaceContext)ctx).buildSurface(px, pz, top, (SurfaceContext)ctx);
            int py = ctx.levels.scale(cell.value);
            for (ColumnDecorator processor : this.getBaseDecorators()) {
                processor.decorate(ctx.buffer, (DecoratorContext)ctx, px, py, pz);
            }
        });
        FastChunk.updateWGHeightmaps(chunk, context.pos);
    }

    public final void func_225550_a_(BiomeManager biomeManager, IChunk chunk, GenerationStage.Carving carving) {
        super.func_225550_a_(biomeManager, (IChunk)new ChunkCarverFix(chunk, this.context.materials), carving);
    }

    public void func_202092_b(WorldGenRegion region) {
        int chunkX = region.func_201679_a();
        int chunkZ = region.func_201680_b();
        IChunk chunk = region.func_212866_a_(chunkX, chunkZ);
        TerraContainer container = this.getBiomeContainer(chunk);
        Biome biome = container.getFeatureBiome();
        DecoratorContext context = this.getContext().decorator(chunk);
        RegionFix regionFix = new RegionFix(region, this);
        BlockPos pos = new BlockPos(context.blockX, 0, context.blockZ);
        this.featureManager.decorate(this, (IWorld)regionFix, chunk, biome, pos);
        this.postProcess(container.getChunkReader(), container, context);
        ((ChunkPrimer)chunk).func_225548_a_(container.bakeBiomes(Environment.isVanillaBiomes()));
        container.getChunkReader().dispose();
    }

    @Override
    public final void postProcess(ChunkReader chunk, TerraContainer container, DecoratorContext context) {
        chunk.iterate(context, (cell, dx, dz, ctx) -> {
            int px = ctx.blockX + dx;
            int pz = ctx.blockZ + dz;
            int py = ctx.chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE_WG, dx, dz);
            ctx.cell = cell;
            ctx.biome = container.getBiome(dx, dz);
            for (ColumnDecorator decorator : this.getPostProcessors()) {
                decorator.decorate(ctx.chunk, (DecoratorContext)ctx, px, py, pz);
            }
        });
    }

    @Override
    public int getTopBlockY(int x, int z, Heightmap.Type type) {
        int chunkX = Size.blockToChunk(x);
        int chunkZ = Size.blockToChunk(z);
        ChunkReader chunk = this.getChunkReader(chunkX, chunkZ);
        Cell<Terrain> cell = chunk.getCell(x, z);
        return this.context.levels.scale(cell.value);
    }

    public BiomeProvider getBiomeProvider() {
        return this.biomeProvider;
    }

    public final int func_207511_e() {
        return this.getContext().levels.worldHeight;
    }

    public final int func_222530_f() {
        return this.getContext().levels.waterLevel;
    }

    public final int func_205470_d() {
        return this.getContext().levels.groundLevel;
    }

    public final TerraContext getContext() {
        return this.context;
    }

    public final Materials getMaterials() {
        return this.context.materials;
    }

    public final GeoManager getGeologyManager() {
        return this.geologyManager;
    }

    public final LayerManager getLayerManager() {
        return this.context.materials.getLayerManager();
    }

    public final SurfaceManager getSurfaceManager() {
        return this.surfaceManager;
    }

    public final List<ColumnDecorator> getBaseDecorators() {
        return this.baseDecorators;
    }

    public final List<ColumnDecorator> getPostProcessors() {
        return this.postProcessors;
    }

    protected TerraContainer getBiomeContainer(IChunk chunk) {
        if (chunk.func_225549_i_() instanceof TerraContainer) {
            return (TerraContainer)chunk.func_225549_i_();
        }
        ChunkReader view = this.getChunkReader(chunk.func_76632_l().field_77276_a, chunk.func_76632_l().field_77275_b);
        TerraContainer container = this.getBiomeProvider().createBiomeContainer(view);
        if (chunk instanceof ChunkPrimer) {
            ((ChunkPrimer)chunk).func_225548_a_((BiomeContainer)container);
        } else if (chunk instanceof FastChunk) {
            ((FastChunk)chunk).setBiomes(container);
        }
        return container;
    }

    protected FeatureManager createFeatureManager(TerraContext context) {
        FeatureModifiers modifiers;
        if (context.terraSettings.features.customBiomeFeatures) {
            Log.info(" - Custom biome features enabled", new Object[0]);
            modifiers = FeatureModifierLoader.load();
        } else {
            modifiers = new FeatureModifiers();
        }
        if (context.terraSettings.features.strataDecorator) {
            modifiers.getPredicates().add(Matchers.stoneBlobs(), FeaturePredicate.DENY);
        }
        if (!context.terraSettings.features.vanillaWaterFeatures) {
            modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_202289_ai), FeaturePredicate.DENY);
            modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_202295_ao), FeaturePredicate.DENY);
        }
        modifiers.getPredicates().add(Matchers.sedimentDisks(), FeaturePredicate.DENY);
        modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_204751_l), (FeaturePredicate)MinDepth.DEPTH55);
        modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_204029_o), (FeaturePredicate)DeepWater.INSTANCE);
        modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_202336_n), (FeaturePredicate)DeepWater.INSTANCE);
        modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_202329_g), (FeaturePredicate)MinHeight.HEIGHT80);
        TreeLine treeLine = new TreeLine(context);
        modifiers.getPredicates().add(FeatureTypes.TREE.matcher(), (FeaturePredicate)treeLine);
        modifiers.getPredicates().add(FeatureMatcher.of(Feature.field_214482_aJ), (FeaturePredicate)treeLine);
        modifiers.getDynamic().add(DynamicMatcher.feature(AbstractTreeFeature.class), treeLine);
        return FeatureManager.create(context.world, SetupHooks.setup(modifiers, context.copy()));
    }

    protected GeoManager createGeologyManager(TerraContext context) {
        return new GeoManager(context);
    }

    protected SurfaceManager createSurfaceManager() {
        SurfaceManager manager = new SurfaceManager();
        manager.replace(Biomes.field_76776_l, new FrozenOcean(this.context, 20, 15));
        manager.replace(Biomes.field_203620_Z, new FrozenOcean(this.context, 30, 30));
        return manager;
    }

    protected List<ColumnDecorator> createBaseDecorators(TerraContext context) {
        ArrayList<ColumnDecorator> processors = new ArrayList<ColumnDecorator>();
        if (context.terraSettings.features.strataDecorator) {
            Log.info(" - Geology decorator enabled", new Object[0]);
            processors.add(new GeologyDecorator(this.geologyManager));
        }
        if (context.terraSettings.features.erosionDecorator) {
            Log.info(" - Erosion decorator enabled", new Object[0]);
            processors.add(new ErosionDecorator(context));
        }
        processors.add(new CoastDecorator(context));
        processors.add(new BedrockDecorator());
        return processors;
    }

    protected List<ColumnDecorator> createFeatureDecorators(TerraContext context) {
        ArrayList<ColumnDecorator> processors = new ArrayList<ColumnDecorator>();
        if (context.terraSettings.features.naturalSnowDecorator) {
            Log.info(" - Natural snow decorator enabled", new Object[0]);
            processors.add(new SnowEroder(context));
        }
        if (context.terraSettings.features.smoothLayerDecorator) {
            Log.info(" - Smooth layer decorator enabled", new Object[0]);
            processors.add(new LayerDecorator(context.materials.getLayerManager()));
        }
        return processors;
    }

    protected RegionCache createRegionCache(TerraContext context) {
        return RegionGenerator.builder().legacy(context.terraSettings.version == 0).pool(ThreadPool.getPool()).factory(context.factory).size(3, 2).build().toCache(false);
    }

    public ChunkReader getChunkReader(int chunkX, int chunkZ) {
        return this.regionCache.getChunk(chunkX, chunkZ);
    }
}

